# -*- coding: utf-8 -*-

# Copyright 2013 Vincent Jacques
# vincent@vincent-jacques.net

# This file is part of AnotherPyGraphvizAgain. http://jacquev6.github.com/AnotherPyGraphvizAgain

# AnotherPyGraphvizAgain is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

# AnotherPyGraphvizAgain is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.

# You should have received a copy of the GNU Lesser General Public License along with AnotherPyGraphvizAgain.  If not, see <http://www.gnu.org/licenses/>.

import AnotherPyGraphvizAgain.Raw as raw
import AnotherPyGraphvizAgain.Compounds as compounds


class Graph(compounds.Graph):
    def __init__(self, name):
        compounds.Graph.__init__(self, name)
        self.__legend = compounds.Cluster("legend").set("label", "Legend")
        self.add(self.__legend)

    def createNodeClass(self, label, attributes):
        def create(id):
            node = compounds.Node(id)
            node.attr._Attributes__attr.update(attributes)
            return node

        self.__legend.add(create(raw.makeId(label)).set("label", label))

        return create

    def createLinkClass(self, label, attributes):
        def create(origin, destination):
            link = compounds.Link(origin, destination)
            link.attr._Attributes__attr.update(attributes)
            return link

        n1 = compounds.Node(raw.makeId(label) + "_1").set("style", "invis").set("shape", "point")
        n2 = compounds.Node(raw.makeId(label) + "_2").set("style", "invis").set("shape", "point")
        self.__legend.add(n1).add(n2).add(create(n1, n2).set("label", label))

        return create
