# -*- coding: utf-8 -*-

# Copyright 2013 Vincent Jacques
# vincent@vincent-jacques.net

# This file is part of AnotherPyGraphvizAgain. http://jacquev6.github.com/AnotherPyGraphvizAgain

# AnotherPyGraphvizAgain is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

# AnotherPyGraphvizAgain is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.

# You should have received a copy of the GNU Lesser General Public License along with AnotherPyGraphvizAgain.  If not, see <http://www.gnu.org/licenses/>.

from .Framework import ConstructionTestCase

import AnotherPyGraphvizAgain.Compounds as gv


class Clusters(ConstructionTestCase(gv.Graph)):
    def testLinkToCluster(self):
        n = gv.Node("node_0")
        c = gv.Cluster("0")
        c.add(gv.Node("node_1"))
        self.g.add(n)
        self.g.add(c)
        self.g.add(gv.Link(n, c))

        self.expect("""digraph "First graph" {compound="true";node_0;subgraph cluster_0{node_1;};node_0->node_1[lhead="cluster_0"];}""")

    def testLinkFromCluster(self):
        n = gv.Node("node_0")
        c = gv.Cluster("0")
        c.add(gv.Node("node_1"))
        self.g.add(n)
        self.g.add(c)
        self.g.add(gv.Link(c, n))

        self.expect("""digraph "First graph" {compound="true";node_0;subgraph cluster_0{node_1;};node_1->node_0[ltail="cluster_0"];}""")

    def testLinkFromToCluster(self):
        c0 = gv.Cluster("0").add(gv.Node("node_0"))
        c1 = gv.Cluster("1").add(gv.Node("node_1"))
        self.g.add(c0)
        self.g.add(c1)
        self.g.add(gv.Link(c0, c1))

        self.expect("""digraph "First graph" {compound="true";subgraph cluster_0{node_0;};subgraph cluster_1{node_1;};node_0->node_1[lhead="cluster_1",ltail="cluster_0"];}""")

    def testLinkToEmptyCluster(self):
        n = gv.Node("node_0")
        c = gv.Cluster("0")

        with self.assertRaises(Exception):
            self.g.add(gv.Link(c, n))
