# -*- coding: utf-8 -*-

# Copyright 2013 Vincent Jacques
# vincent@vincent-jacques.net

# This file is part of AnotherPyGraphvizAgain. http://jacquev6.github.com/AnotherPyGraphvizAgain

# AnotherPyGraphvizAgain is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

# AnotherPyGraphvizAgain is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.

# You should have received a copy of the GNU Lesser General Public License along with AnotherPyGraphvizAgain.  If not, see <http://www.gnu.org/licenses/>.

from .Framework import ConstructionTestCase

import AnotherPyGraphvizAgain.AutoLegends as gv


class Legends(ConstructionTestCase(gv.Graph)):
    def testOneNodeClass(self):
        BlueNode = self.g.createNodeClass("Blue node", {"color": "blue"})

        self.expect("""digraph "First graph" {compound="true";subgraph cluster_legend{label="Legend";Blue_20node[color="blue",label="Blue node"];};}""")

    def testOneLinkClass(self):
        BlueLink = self.g.createLinkClass("Blue link", {"color": "blue"})

        self.expect("""digraph "First graph" {compound="true";subgraph cluster_legend{label="Legend";Blue_20link_1[shape="point",style="invis"];Blue_20link_2[shape="point",style="invis"];Blue_20link_1->Blue_20link_2[color="blue",label="Blue link"];};}""")

    def testOneNode(self):
        BlueNode = self.g.createNodeClass("Blue node", {"color": "blue"})
        self.g.add(BlueNode("node_0"))

        self.expect("""digraph "First graph" {compound="true";node_0[color="blue"];subgraph cluster_legend{label="Legend";Blue_20node[color="blue",label="Blue node"];};}""")
