# -*- coding: utf-8 -*-

# Copyright 2013 Vincent Jacques
# vincent@vincent-jacques.net

# This file is part of AnotherPyGraphvizAgain. http://jacquev6.github.com/AnotherPyGraphvizAgain

# AnotherPyGraphvizAgain is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

# AnotherPyGraphvizAgain is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.

# You should have received a copy of the GNU Lesser General Public License along with AnotherPyGraphvizAgain.  If not, see <http://www.gnu.org/licenses/>.

import unittest

import AnotherPyGraphvizAgain.Raw as gv


class MakeId(unittest.TestCase):
    def testKeepLetters(self):
        self.assertEqual(gv.makeId("abcdefghijklmnopqrstuvwxyz"), "abcdefghijklmnopqrstuvwxyz")
        self.assertEqual(gv.makeId("ABCDEFGHIJKLMNOPQRSTUVWXYZ"), "ABCDEFGHIJKLMNOPQRSTUVWXYZ")

    def testKeepDigits(self):
        self.assertEqual(gv.makeId("a0123456789"), "a0123456789")

    def testReplaceStrangeCharacters(self):
        self.assertEqual(gv.makeId("#"), "_23")
        self.assertEqual(gv.makeId("_"), "_5f")
        self.assertEqual(gv.makeId("*"), "_2a")
        self.assertEqual(gv.makeId(" "), "_20")
        self.assertEqual(gv.makeId("\2"), "_02")
        self.assertEqual(gv.makeId("\""), "_22")

    def testDontStartWithDigit(self):
        self.assertEqual(gv.makeId("57a"), "_357a")

    def testInteger(self):
        self.assertEqual(gv.makeId(57), "_357")

    def testNone(self):
        self.assertEqual(gv.makeId(None), "None")

    def testTuple(self):
        self.assertEqual(gv.makeId((42, "a")), "_2842_2c_20_27a_27_29")
