# -*- coding: utf-8 -*-
"""
Keys with leading underscore are our custom provider-specific data.

Authomatic Example

Example usage of the Authomatic authentication / authorization library for Python web applications.

http://authomatic-example.appspot.com
"""

from authomatic.providers import oauth2, oauth1, openid, gaeopenid
import authomatic
import copy

DEFAULT_MESSAGE = 'Have you got a bandage?'

SECRET = '+DRpGjQzBpKjBWozhS!tt2[a6kY6^z+F;<&b[?WAcbt?yi]98PX6 +|]H39+c}fK'

DEFAULTS = {
    'popup': True,
}

AUTHENTICATION = {
    'openid': {
        'class_': openid.OpenID,
    },
    'gae-openid': {
        'class_': gaeopenid.GAEOpenID,
    },
}

OAUTH1 = {
    'bitbucket': {
        'class_': oauth1.Bitbucket,
        'consumer_key': 'kL2rJAuRzrsguTsZXa',
        'consumer_secret': 'mZYsDaQDZmvUjStUCCpDBnLXJBuSHGG8',
        'id': authomatic.provider_id(),
        '_apis': {
            'Get repos you follow': ('GET', 'https://api.bitbucket.org/1.0/user/repositories/overview'),
            'Get your privileges': ('GET', 'https://api.bitbucket.org/1.0/user/privileges'),
        }
    },
    
    'flickr': {
        'class_': oauth1.Flickr,
        'consumer_key': 'e186ab1fa3d674587e0520105c5a20a5',
        'consumer_secret': 'd6c21896983ff86d',
        'id': authomatic.provider_id(),
        '_apis': {
            'List your photos': ('GET', 'http://api.flickr.com/services/rest?method=flickr.activity.userPhotos&format=json'),
            'List your comments': ('GET', 'http://api.flickr.com/services/rest?method=flickr.activity.userComments&format=json'),
        },
    },
    
    'meetup': {
         'class_': oauth1.Meetup,
         'consumer_key': 'k1bfc31k357d2m3isb2s0g9hmr',
         'consumer_secret': 'r51oe2dgtnsttqt13biootr6sf',
           'id': authomatic.provider_id(),
    },
    
    'plurk': {
        'class_': oauth1.Plurk,
        'consumer_key': 'Fc5HD5AQFiXc',
        'consumer_secret': 'm7zy1cnIh1iOQIhWGRXFFQK12XP3rKTD',
        'id': authomatic.provider_id(),
        '_apis': {
            'Get your plurks': ('GET', 'http://www.plurk.com/APP/Timeline/getPlurks?filter=only_user'),
            'Plurk something': ('POST', 'http://www.plurk.com/APP/Timeline/plurkAdd?qualifier=says&content={message}'),
        }
    },
    
    'twitter': {
        'class_': oauth1.Twitter,
        'consumer_key': 'POtNH5829cfS9XjXQ6Q9Hg',
        'consumer_secret': 'kUwF5X6ZXXXeWpoVwgnx2XUay1hz1C4X6dwWtG4bc',
        'id': authomatic.provider_id(),
        '_apis': {
            'Get your recent tweets': ('GET', 'https://api.twitter.com/1.1/statuses/user_timeline.json'),
            'Post a tweet': ('POST', 'https://api.twitter.com/1.1/statuses/update.json?status={message}', 'Message', 'Have you got a bandage?'),
        },
    },
    
    'tumblr': {
        'class_': oauth1.Tumblr,
        'consumer_key': '4GAOCDTsReb3EtaIyzFSc6Z964sHSq7HLyyx52mid79Rr8dBpy',
        'consumer_secret': 'vtvSiDCmQmPXGid9yR1ZKesMH17jqcUWdfhfSbRje8x93bQUxQ',
        'id': authomatic.provider_id(),
        '_apis': {
            'Get your likes': ('GET', 'https://api.tumblr.com/v2/user/likes'),
            'Follow': ('POST', 'https://api.tumblr.com/v2/user/follow?url={message}', 'Tumblr blog URL', 'peterhudec.tumblr.com'),
        },
    },
    
    'ubuntuone': {
        'class_': oauth1.UbuntuOne,
        'consumer_key': 'ubuntuone', # Ubuntu gives has the same key and secret for everyone.
        'consumer_secret': 'hammertime',
        'id': authomatic.provider_id(),
        '_name': 'UbuntuOne',
        '_apis': {
            'Get your U1 quotas': ('GET', 'https://one.ubuntu.com/api/quota/'),
        },
    },
    
    'vimeo': {
        'class_': oauth1.Vimeo,
        'consumer_key': 'aa7914126ee2aca3b1c5f40351251fde97fbb8c3',
        'consumer_secret': '79f58b2284321458253c36dca0b7d9da46f9be9e',
        'id': authomatic.provider_id(),
        '_apis': {
            'Get your activity': ('GET', 'http://vimeo.com/api/rest/v2?method=vimeo.activity.happenedToUser&format=json&user_id={user.id}'),
        },
    },
    
    'xero': {
        'class_': oauth1.Xero,
        'consumer_key': 'HNEJDOQ41HYAY0SUZAWGSYZEATSR27',
        'consumer_secret': 'H8ZCRW1CK4J1MPNWYWEPKBCLKETDCW',
        'id': authomatic.provider_id(),
    },

    'xing': {
        'class_': oauth1.Xing,
        'consumer_key': '8d9719f84fe6b83b09b9',
        'consumer_secret': 'cce1a03f8e74409dddf47cee46abc24b4261bdac',
        'id': authomatic.provider_id(),
        '_icon': 'https://www.xing.com/favicon.ico',
        '_apis': {
            'Get job recommendations': ('GET', "https://api.xing.com/v1/users/{user.id}/jobs/recommendations"),
            'Get activity stream': ('GET', "https://api.xing.com/v1/users/{user.id}/feed"),
        },
    },
    
    'yahoo': {
        'class_': oauth1.Yahoo,
        'consumer_key': 'dj0yJmk9WnBwa1pKTW9uYUI2JmQ9WVdrOWFXUlRPSEpSTm5FbWNHbzlNakExTURrek56YzJNZy0tJnM9Y29uc3VtZXJzZWNyZXQmeD02Ng--',
        'consumer_secret': 'e976fba63c371f21e998d7e0e71bb815770990f6',
        'id': authomatic.provider_id(),
        '_apis': {
            'Get recent emails': ('GET', "https://query.yahooapis.com/v1/yql?q=select%20*%20from%20ymail.messages%20where%20numMid%3D'5'&format=json&securityLevel=user"),
        },
    },
}

OAUTH2 = {
    'behance': {
         'class_': oauth2.Behance,
         'consumer_key': '8cVbIs3FAuz5COAg3BZfbhiqA8nwgwAr',
         'consumer_secret': 'bqL4Hhc86e3SCB.GMQxFq.L.ZeWR29PR',
           'id': authomatic.provider_id(),
         'scope': oauth2.Behance.user_info_scope + ['post_as'],
        '_apis': {
                  'Get your collections.': ('GET', 'http://behance.net/v2/users/{user.username}/collections'),
                  'Get your statistics.': ('GET', 'http://behance.net/v2/users/{user.username}/stats'),
                  'Follow a user.': ('POST', 'http://behance.net/v2/users/{message}/follow', 'Username or ID', 'peterhudec'),
        },
    },
          
    'bitly': {
        'class_': oauth2.Bitly,
        'consumer_key': '755df4144be8506d794f5002eed8d614c339c938',
        'consumer_secret': '7da70c0ccd81e15dc4f991c4b2235f9aff1e260d',
          'id': authomatic.provider_id(),
        'scope': oauth2.Bitly.user_info_scope,
        '_apis': {
            'Get your link history': ('GET', 'https://api-ssl.bitly.com/v3/user/link_history'),
            'Shorten a URL': ('GET', 'https://api-ssl.bitly.com/v3/shorten?longUrl={message}', 'URL', 'http://peterhudec.com'),
        },
    },
          
    'cosm': {
         'class_': oauth2.Cosm,
         'consumer_key': 'a612e3e36a24a9962987',
         'consumer_secret': '0rcsB-a4cDn8weHZIBZtrTHdJTIo30FfuUnXax5wrujhlc4f',
         'id': authomatic.provider_id(),
         'scope': oauth2.Cosm.user_info_scope,
    },
          
    'deviantart': {
         'class_': oauth2.DeviantART,
         'consumer_key': '405',
         'consumer_secret': 'ace732d6dc0b14c144171d1757cc93f9',
         'id': authomatic.provider_id(),
         'scope': oauth2.DeviantART.user_info_scope,
    },
    
    'facebook': {
           
        'class_': oauth2.Facebook,
        'consumer_key': '249464911861131',
        'consumer_secret': '8edbb3eb10e76f14f85fa491ec18d8fd',
        'id': authomatic.provider_id(),
        'scope': oauth2.Facebook.user_info_scope + ['publish_stream'],
        '_apis': {
                  'Get your recent statuses': ('GET', 'https://graph.facebook.com/{user.id}/feed'),
                  'Share this page': ('POST', 'https://graph.facebook.com/{user.id}/feed?message={message}&link=http://authomatic-example.appspot.com',
                                      'Enter comment', 'This app is ...'),
        },
    },
    
    'foursquare': {
           
        'class_': oauth2.Foursquare,
        'consumer_key': 'TKZGINZCITUASFKAMWPK23Y4HYKLEDZUQ5X0FRJCXIUF5RMF',
        'consumer_secret': '2S5HTXQQN30MTX4I1VCMDQUPGCASDQXI4BZWFVCFJTJQZ2ZK',
        'id': authomatic.provider_id(),
        'scope': oauth2.Foursquare.user_info_scope,
        '_apis': {
                  'Get your recent checkins': ('GET', 'https://api.foursquare.com/v2/users/{user.id}/checkins'),
                  'Get your badges': ('GET', 'https://api.foursquare.com/v2/users/{user.id}/badges'),
        },
    },
    
    'github': {
           
        'class_': oauth2.GitHub,
        'consumer_key': '881666b6af8757af1607',
        'consumer_secret': '5f7dcb4e5ed1d18befdece1f8f4d333ae1becf86',
        'id': authomatic.provider_id(),
        'scope': oauth2.GitHub.user_info_scope,
        '_apis': {
                  'Get your events': ('GET', 'https://api.github.com/users/{user.username}/events'),
                  'Get your watched repos': ('GET', 'https://api.github.com/user/subscriptions'),
        },
    },
    
    'google': {
        'class_': oauth2.Google,
        'consumer_key': '327027207144.apps.googleusercontent.com',
        'consumer_secret': '99gsojRXjaU38_EQwsbOBJ8h',
          'id': authomatic.provider_id(),
        'scope': oauth2.Google.user_info_scope + [
            'https://www.googleapis.com/auth/calendar',
            'https://mail.google.com/mail/feed/atom',
            'https://www.googleapis.com/auth/drive',
            'https://gdata.youtube.com'],
        '_apis': {
                  'List your calendars': ('GET', 'https://www.googleapis.com/calendar/v3/users/me/calendarList'),
                  'List your YouTube playlists': ('GET', 'https://gdata.youtube.com/feeds/api/users/default/playlists?alt=json'),
        },
    },
    
    'linkedin': {
        'class_': oauth2.LinkedIn,
        'consumer_key': 'vwivyjqp2nur',
        'consumer_secret': '7EMJZcc7qhWMxmRo',
          'id': authomatic.provider_id(),
        'scope': oauth2.LinkedIn.user_info_scope + ['rw_nus', 'r_network'],
        '_name': 'LinkedIn',
        '_apis': {
            'List your connections': ('GET', 'https://api.linkedin.com/v1/people/~/connections'),
        },
    },
    
    'paypal': {
         'class_': oauth2.PayPal,
         'consumer_key': 'AR58GRBgr81q6vZQOUxwB1OF9_62PXb1CouQVaENf5dbTLgPkr3K7YZXgnc6',
         'consumer_secret': 'EJqCvRAZ4sFobX_NlzyVMyD3PSXH41pAWpeCFpiepworglq_f_5dl3TrCYFl',
           'id': authomatic.provider_id(),
         'scope': oauth2.PayPal.user_info_scope,
         '_name': 'PayPal',
    },
    
    'reddit': {
         'class_': oauth2.Reddit,
         'consumer_key': 'qTUbGtKBpK8HhQ',
         'consumer_secret': 'Wh7keGWMqdaTar6wjuqXzuuFc4s',
           'id': authomatic.provider_id(),
         'scope': oauth2.Reddit.user_info_scope,
    },
    
    'viadeo': {
        'class_': oauth2.Viadeo,
        'consumer_key': 'AuthomaticDevNyWlGx',
        'consumer_secret': 'NvQuiowaMRBcs',
          'id': authomatic.provider_id(),
        'scope': oauth2.Viadeo.user_info_scope,
        '_apis': {
            'Get your inbox': ('GET', 'https://api.viadeo.com/me/inbox'),
            'Get your newsfeed': ('GET', 'https://api.viadeo.com/me/home_newsfeed'),
            'Post a status': ('POST', 'https://api.viadeo.com/status?message={message}', 'Status', DEFAULT_MESSAGE),
        },
    },
    
    'vk': {
        'class_': oauth2.VK,
        'consumer_key': '3617830',
        'consumer_secret': 'xdYC4nJWkSrvLDdEEAoX',
        'id': authomatic.provider_id(),
        'scope': oauth2.VK.user_info_scope + ['1026'],
        '_name': 'VK',
        '_apis': {
            'Get your history': ('GET', 'https://api.vk.com/method/activity.getHistory'),
            'Get your news': ('GET', 'https://api.vk.com/method/activity.getNews'),
            'Get your friends': ('GET', 'https://api.vk.com/method/friends.get'),
        },
    },
    
    'windows_live': {
        'class_': oauth2.WindowsLive,
        'consumer_key': '000000004C0ECA01',
        'consumer_secret': '1lTeXWQepYIvAvRo6aZLXm0pPpOjRx3c',
        'id': authomatic.provider_id(),
        'scope': oauth2.WindowsLive.user_info_scope + ['wl.skydrive'],
        '_name': 'Live',
        '_apis': {
            'List your recent documents': ('GET', 'https://apis.live.net/v5.0/me/skydrive/recent_docs'),
            'List your contacts': ('GET', 'https://apis.live.net/v5.0/me/contacts'),
        },
    },
    
    'yammer': {
        'class_': oauth2.Yammer,
        'consumer_key': 'KEaq1g3Zq7r4MmgV0hQhA',
        'consumer_secret': 'psssBycSSoIGp3H2N7a5FovaeC4F8zLNE096a3zbhq8',
          'id': authomatic.provider_id(),
        'scope': oauth2.Yammer.user_info_scope,
        '_apis': {
            'Your feed': ('GET', 'https://www.yammer.com/api/v1/messages/my_feed.json'),
        },
    },
    
    'yandex': {
         'class_': oauth2.Yandex,
         'consumer_key': '9237fa38855d44ffaf03418b97ebdeb5',
         'consumer_secret': 'eb7b3dc2d35046bfad03de07c7c98ae3',
           'id': authomatic.provider_id(),
         'scope': oauth2.Yandex.user_info_scope,
    },
}

# Concatenate the configs.
config = copy.deepcopy(OAUTH1)
config.update(OAUTH2)
config.update(AUTHENTICATION)
config['__defaults__'] = DEFAULTS
