from setuptools import setup
import os

import B_pp

here = os.path.abspath(os.path.dirname(__file__))

long_description = """
The B Preprocessor
    A code template processor

    What is this?
        This is a code templating pre-processor. In my work I often have to
        write code which runs on multiple data files. The code has to be the
        same, but the files differ in subtle ways: the number of files, the
        format of the files, etc. Instead of writing one piece of code, then
        tweaking it to work for each case, I write a B template, and put all
        of the file-specific-subtleties into meta-data text files, and the B
        pre-processor handles all of the case specific tweaking.

    Why would I want this?
        Readability
            Everything is text files and python scripts. The output of the
            preprocessor looks like normal code that was written from scratch.
            I send code generated by the pre-processor to my boss all the time.
            It makes him happy because it looks like code he writes; It makes
            me happy because I don't have to be inefficient and write code his
            way.
        Flexibility
            The preprocessor uses simple ideas: replacement, iteration, files
            are treated as strings, the template boilerplate is handled with
            the same rules as everything else. You can do some crazy things
            with a little creativity.

    Why didn't you just learn to use one of the other template scripting
    languages?
        Frankly, I wrote the first version of this over the course of two
        hours. I needed something which worked, and I needed it fast. It would
        have taken me longer to learn something new, than to make something
        new.
    Why B?
        B comes before C! Most of my work coding is in C/C++. Now I can say
        things like, "I wrote you A B C... ++ template for that." Actually, no,
        thats a really limp joke.

    when install with setuptools (or variant), an executable 'B' is added
        to the user's path.
"""

setup(
    name='B_pp',
    version=B_pp.__version__,
    url='http://github.com/JohnFNovak/B_pp/',
    license='Public Domain',
    author='John F Novak',
    author_email='john.franc.novak@gmail.com',
    description='A code template processor',
    long_description=long_description,
    packages=['B_pp'],
    include_package_data=True,
    platforms='any',
    entry_points={
        'console_scripts': [
            'B = B_pp.B_pp:main',
        ]
    },
    classifiers=[
        'Programming Language :: Python',
        'Development Status :: 5 - Production/Stable',
        'Natural Language :: English',
        'Environment :: Console',
        'License :: Public Domain',
        'Operating System :: OS Independent',
        'Topic :: Software Development'
        ]
)
