#!/usr/bin/python
#coding:utf-8

"""You can write a BEAUTIFUL HTML!"""
__author__="Alice"
__version__="1.0"

from css.LBcss import LittleBeautifulCSS

class BeautifulHTML:
	"""You can write a BEAUIFUL HTML."""
	def __init__(self,printout=True):
		self.item = ""
		self.out = printout
		self.tags = []
		
	def write(self,str):
		""" Add a tag."""
		self.item += str+"\n"
		self.tags.append(str)
		if self.out:
			return self.item
		
	def indent(self,str,block=1):
		""" Add a tag with indent."""
		if block == 0: return False
		self.item += "\t"*block+str+"\n"
		self.tags.append(str)
		if self.out:
			return self.item
		
	def delete(self):
		""" Delete a just before tag. and return true."""
		delitem = self.tags[-1]
		indexes = self.item.index(delitem)
		self.item = self.item[:indexes]
		self.tags = self.tags[:-1]
		if self.out: return True
		
	def addoption(self,tag,data,content,indent=False,block=0,closetag=True):
		""" Write a tag with any option.
		
		Arguments:
		-------------
		1, tag -- tag name
		2, data -- directory or string.
		3, content -- content
		4, indent -- if you add a tag with indent, write True.
		5, block -- indent block
		6, closetag -- if you don't want closetag, write True.

		Example:
		-------------
		>>> html = BeautifulHTML()
		>>> html.addoption("a",data={"href":"http://test.com/","class":"sample"},content="here",indent=True,block="2")
		'\\t\\t<a class="sample" href="http://test.com/">here</a>\\n'"""
		if indent:
			if block == 0: block = 1
			string = "\t"*block+"<%s " % tag
		else: 
			string = "<%s " % tag
		if isinstance(data,dict):
			option = ""
			for i,j in data.iteritems():
				option += '%s="%s" '% (i,j)
			if closetag==False:
				string += option+" />\n"
			else: string += option+">"+content+"</%s>\n" % tag
		elif isinstance(data,str):
			if closetag==False:
				string += data+" />\n"
			else: string += data+">"+content+"</%s>\n" % tag
		self.item += string
		self.tags.append(string)
		if self.out:
			return self.item
			
	def br(self):
		""" Write a 'br' tag."""
		self.item += "<br />\n"
		
		
	def noclosetag(self,tag):
		""" Write a tag witout  closetag.
		
		ex):
		>>> html = BeautifulHTML()
		>>> html.noclosetag("meta")
		'<meta />'
		"""
		self.item += "<%s />" % tag
	
	def setcss(self,printout=True):
		return LittleBeautifulCSS(printout)
		
	def writecss(self,release,indent=False,block=0):
		if isinstance(release,list) != True: return False
		if indent:
			self.item += "\t"*block+"<style type='text/css'>\n"
			self.item += str("\t"*block).join(release)
			self.item += "\t"*block+"</style>\n"
		else: 
			self.item += "<style type='text/css'>\n"
			self.item += "".join(release)
			self.item += "</style>\n"
		if self.out: return self.item
	
	def printout(self):
		""" Show tags """
		return self.item 
		
	def __str__(self):
		return self.item
		
	def encoding(self):
		""" Show encoding """
		return "utf-8"
		
	def length(self):
		""" Show length of tag line. """ 
		return len(self.tags)
		
		
		
