#!/usr/bin/python
#coding:utf-8

class LittleBeautifulCSS:
	def __init__(self,printout=True):
		self.item = ""
		self.css = []
		self.out = printout
		
	def element(self,name,body):
		if isinstance(body,dict):
			string = ""
			string+="%s { " % name
			for i,j in body.iteritems():
				string += i+": "+j+"; "
			string += "}\n"
			self.item += string
			self.css.append(string)
		elif isinstance(body,list):
			for i in range(len(body)):
				if body[i][-1] != ";":
					body[i] += ";"
			string = "%s { " % name
			string += ' '.join(body)
			string += " }\n"
			self.item += string
			self.css.append(string)
		if self.out: return self.item

	def delete(self):
		delitem = self.css[-1]
		indexes = self.item.index(delitem)
		self.item = self.item[:indexes]
		if self.out: return True
		
	def __str__(self):
		return self.item
		
	def release(self): return self.css
	
	def length(self): return len(self.css)
		
	
		
	