# -*- coding: utf-8 -*-

# BibReview
# Copyright (C) 2012 Jean-Baptiste LAMY (jibalamy at free . fr)
# BibReview is developped by Jean-Baptiste LAMY, at LIM&BIO,
# UFR SMBH, Université Paris 13, Sorbonne Paris Cité.

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


__all__ = ["ABBREVS"]

import sys, os, os.path, bibreview.globdef

if sys.version[0] == "2":
  s = open(os.path.join(bibreview.globdef.DATADIR, "abbrev.txt")).read().decode("utf8")
else:
  s = open(os.path.join(bibreview.globdef.DATADIR, "abbrev.txt")).read()

ABBREVS = {}
for ligne in s.split(u"\n"):
  if ligne:
    noms, abbrev = ligne.split(u"\t")
    for nom in noms.split(u";"):
      ABBREVS[nom.strip().upper().replace(u"... ", u"")] = abbrev.strip()

del s
