# By Justin Walgran
# Copyright (c) 2012 Azavea, Inc.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation
# files (the "Software"), to deal in the Software without
# restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following
# conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.

class Result(object):

    def __init__(self):
        self._messages = None
        self._warnings = None
        self._errors = None
        self._good = False

    @property
    def messages(self):
        """
        A list of informational topics generated by analysing some content
        """
        return self._messages

    @property
    def warnings(self):
        """
        A list of warning topics generated by analysing some content
        """
        return self._warnings

    @property
    def errors(self):
        """
        A list of warning topics generated by analysing some content
        """
        return self._errors

    @property
    def good(self):
        """
        A boolean that indicates whether or not the analyzed content is 'good'
        """
        return self._good

    @property
    def errors_warnings_and_messages_as_string(self):
        output = None
        if self.errors:
            output = '\n'.join(self.errors)

        if self.warnings:
            if output:
                output += '\n' + '\n'.join(self.warnings)
            else:
                output = '\n'.join(self.warnings)

        if self.messages:
            if output:
                output += '\n' + '\n'.join(self.messages)
            else:
                output = '\n'.join(self.messages)

        return output

    def add_message(self, message):
        if message is not None:
            if self._messages is None:
                self._messages = []
            self._messages.append(message)

    def add_messages(self, message_list):
        if message_list is not None:
            if self._messages is None:
                self._messages = []
            self._messages.extend(message_list)

    def add_warning(self, warning):
        if warning is None:
            return

        if self._warnings is None:
            self._warnings = []
        self._warnings.append(warning)

    def add_error(self, error):
        if error is None:
            return

        if self._errors is None:
            self._errors = []
        self._errors.append(error)

    def mark_as_good(self):
        self._good = True

    def mark_as_bad(self):
        self._good = False

    def __str__(self):
        return self.__unicode__()

    def __unicode__(self):
        return self.errors_warnings_and_messages_as_string
