# Copyright (C) 2010 Richard Lincoln
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


""" Defines a map of class names to their module.
"""

pkg_map = {
    "IEC61970CIMVersion": "cim",
    "Element": "cim",
    "IdentifiedObject": "cim.core",
    "PowerSystemResource": "cim.core",
    "Equipment": "cim.core",
    "ConductingEquipment": "cim.core",
    "Curve": "cim.core",
    "BasicIntervalSchedule": "cim.core",
    "IrregularIntervalSchedule": "cim.core",
    "RegularIntervalSchedule": "cim.core",
    "ConnectivityNodeContainer": "cim.core",
    "EquipmentContainer": "cim.core",
    "CurveData": "cim.core",
    "Bay": "cim.core",
    "PSRType": "cim.core",
    "GeographicalRegion": "cim.core",
    "Terminal": "cim.core",
    "OperatingParticipant": "cim.core",
    "VoltageLevel": "cim.core",
    "BasePower": "cim.core",
    "Unit": "cim.core",
    "ModelingAuthority": "cim.core",
    "BaseVoltage": "cim.core",
    "SubGeographicalRegion": "cim.core",
    "PsrList": "cim.core",
    "Substation": "cim.core",
    "ReportingGroup": "cim.core",
    "Company": "cim.core",
    "ReportingSuperGroup": "cim.core",
    "RegularTimePoint": "cim.core",
    "IrregularTimePoint": "cim.core",
    "ModelingAuthoritySet": "cim.core",
    "OperatingShare": "cim.core",
    "PowerTransformer": "cim.wires",
    "RegulatingCondEq": "cim.wires",
    "FrequencyConverter": "cim.wires",
    "ShuntCompensator": "cim.wires",
    "HeatExchanger": "cim.wires",
    "RegulatingControl": "cim.wires",
    "ReactiveCapabilityCurve": "cim.wires",
    "Line": "cim.wires",
    "Connector": "cim.wires",
    "Junction": "cim.wires",
    "Ground": "cim.wires",
    "Conductor": "cim.wires",
    "TransformerWinding": "cim.wires",
    "WireArrangement": "cim.wires",
    "EnergyConsumer": "cim.wires",
    "Switch": "cim.wires",
    "ProtectedSwitch": "cim.wires",
    "LoadBreakSwitch": "cim.wires",
    "ACLineSegment": "cim.wires",
    "Plant": "cim.wires",
    "WireType": "cim.wires",
    "RegulationSchedule": "cim.wires",
    "WindingTest": "cim.wires",
    "MutualCoupling": "cim.wires",
    "Disconnector": "cim.wires",
    "SeriesCompensator": "cim.wires",
    "GroundDisconnector": "cim.wires",
    "SynchronousMachine": "cim.wires",
    "CompositeSwitch": "cim.wires",
    "TapChanger": "cim.wires",
    "PhaseTapChanger": "cim.wires",
    "RectifierInverter": "cim.wires",
    "StaticVarCompensator": "cim.wires",
    "RatioTapChanger": "cim.wires",
    "ConductorType": "cim.wires",
    "VoltageControlZone": "cim.wires",
    "EnergySource": "cim.wires",
    "Fuse": "cim.wires",
    "Jumper": "cim.wires",
    "DCLineSegment": "cim.wires",
    "Breaker": "cim.wires",
    "BusbarSection": "cim.wires",
    "TopologicalIsland": "cim.topology",
    "ConnectivityNode": "cim.topology",
    "TopologicalNode": "cim.topology",
    "BusNameMarker": "cim.topology",
    "ClearanceTag": "cim.outage",
    "ClearanceTagType": "cim.outage",
    "OutageSchedule": "cim.outage",
    "SwitchingOperation": "cim.outage",
    "SteamSupply": "cim.generation.generation_dynamics",
    "FossilSteamSupply": "cim.generation.generation_dynamics",
    "HeatRecoveryBoiler": "cim.generation.generation_dynamics",
    "PWRSteamSupply": "cim.generation.generation_dynamics",
    "PrimeMover": "cim.generation.generation_dynamics",
    "Supercritical": "cim.generation.generation_dynamics",
    "CombustionTurbine": "cim.generation.generation_dynamics",
    "HydroTurbine": "cim.generation.generation_dynamics",
    "Subcritical": "cim.generation.generation_dynamics",
    "CTTempActivePowerCurve": "cim.generation.generation_dynamics",
    "SteamTurbine": "cim.generation.generation_dynamics",
    "DrumBoiler": "cim.generation.generation_dynamics",
    "BWRSteamSupply": "cim.generation.generation_dynamics",
    "LevelVsVolumeCurve": "cim.generation.production",
    "FossilFuel": "cim.generation.production",
    "SteamSendoutSchedule": "cim.generation.production",
    "EmissionCurve": "cim.generation.production",
    "CombinedCyclePlant": "cim.generation.production",
    "StartIgnFuelCurve": "cim.generation.production",
    "HydroGeneratingEfficiencyCurve": "cim.generation.production",
    "StartRampCurve": "cim.generation.production",
    "GeneratingUnit": "cim.generation.production",
    "NuclearGeneratingUnit": "cim.generation.production",
    "WindGeneratingUnit": "cim.generation.production",
    "StartMainFuelCurve": "cim.generation.production",
    "StartupModel": "cim.generation.production",
    "AirCompressor": "cim.generation.production",
    "HeatInputCurve": "cim.generation.production",
    "CogenerationPlant": "cim.generation.production",
    "ShutdownCurve": "cim.generation.production",
    "InflowForecast": "cim.generation.production",
    "TargetLevelSchedule": "cim.generation.production",
    "HydroGeneratingUnit": "cim.generation.production",
    "EmissionAccount": "cim.generation.production",
    "GrossToNetActivePowerCurve": "cim.generation.production",
    "HydroPumpOpSchedule": "cim.generation.production",
    "Reservoir": "cim.generation.production",
    "CAESPlant": "cim.generation.production",
    "GenUnitOpCostCurve": "cim.generation.production",
    "PenstockLossCurve": "cim.generation.production",
    "HydroPump": "cim.generation.production",
    "GenUnitOpSchedule": "cim.generation.production",
    "FuelAllocationSchedule": "cim.generation.production",
    "HeatRateCurve": "cim.generation.production",
    "IncrementalHeatRateCurve": "cim.generation.production",
    "ThermalGeneratingUnit": "cim.generation.production",
    "TailbayLossCurve": "cim.generation.production",
    "HydroPowerPlant": "cim.generation.production",
    "PowerCutZone": "cim.load_model",
    "LoadResponseCharacteristic": "cim.load_model",
    "EnergyArea": "cim.load_model",
    "LoadArea": "cim.load_model",
    "StationSupply": "cim.load_model",
    "SubLoadArea": "cim.load_model",
    "ConformLoad": "cim.load_model",
    "Load": "cim.load_model",
    "NonConformLoad": "cim.load_model",
    "InductionMotorLoad": "cim.load_model",
    "LoadGroup": "cim.load_model",
    "NonConformLoadGroup": "cim.load_model",
    "Season": "cim.load_model",
    "SeasonDayTypeSchedule": "cim.load_model",
    "ConformLoadSchedule": "cim.load_model",
    "NonConformLoadSchedule": "cim.load_model",
    "CustomerLoad": "cim.load_model",
    "DayType": "cim.load_model",
    "ConformLoadGroup": "cim.load_model",
    "OperationalLimit": "cim.operational_limits",
    "CurrentLimit": "cim.operational_limits",
    "BranchGroup": "cim.operational_limits",
    "BranchGroupTerminal": "cim.operational_limits",
    "ApparentPowerLimit": "cim.operational_limits",
    "OperationalLimitSet": "cim.operational_limits",
    "VoltageLimit": "cim.operational_limits",
    "ActivePowerLimit": "cim.operational_limits",
    "OperationalLimitType": "cim.operational_limits",
    "Control": "cim.meas",
    "Measurement": "cim.meas",
    "StringMeasurement": "cim.meas",
    "Discrete": "cim.meas",
    "ValueAliasSet": "cim.meas",
    "MeasurementValue": "cim.meas",
    "DiscreteValue": "cim.meas",
    "Limit": "cim.meas",
    "AnalogLimit": "cim.meas",
    "LimitSet": "cim.meas",
    "AccumulatorLimitSet": "cim.meas",
    "SetPoint": "cim.meas",
    "Command": "cim.meas",
    "StringMeasurementValue": "cim.meas",
    "ValueToAlias": "cim.meas",
    "ControlType": "cim.meas",
    "AnalogLimitSet": "cim.meas",
    "Accumulator": "cim.meas",
    "AccumulatorLimit": "cim.meas",
    "MeasurementValueSource": "cim.meas",
    "AnalogValue": "cim.meas",
    "Analog": "cim.meas",
    "MeasurementType": "cim.meas",
    "Quality61850": "cim.meas",
    "MeasurementValueQuality": "cim.meas",
    "AccumulatorValue": "cim.meas",
    "RemotePoint": "cim.scada",
    "RemoteControl": "cim.scada",
    "RemoteUnit": "cim.scada",
    "CommunicationLink": "cim.scada",
    "RemoteSource": "cim.scada",
    "StateVariable": "cim.state_variables",
    "SvVoltage": "cim.state_variables",
    "SvShuntCompensatorSections": "cim.state_variables",
    "SvPowerFlow": "cim.state_variables",
    "SvStatus": "cim.state_variables",
    "SvTapStep": "cim.state_variables",
    "SvInjection": "cim.state_variables",
    "EquivalentEquipment": "cim.equivalents",
    "EquivalentShunt": "cim.equivalents",
    "EquivalentBranch": "cim.equivalents",
    "EquivalentNetwork": "cim.equivalents",
    "ContingencyElement": "cim.contingency",
    "ContingencyEquipment": "cim.contingency",
    "Contingency": "cim.contingency",
    "RecloseSequence": "cim.protection",
    "ProtectionEquipment": "cim.protection",
    "CurrentRelay": "cim.protection",
    "SynchrocheckRelay": "cim.protection",
    "AltTieMeas": "cim.control_area",
    "AltGeneratingUnitMeas": "cim.control_area",
    "ControlArea": "cim.control_area",
    "TieFlow": "cim.control_area",
    "ControlAreaGeneratingUnit": "cim.control_area",
}
