# Copyright (C) 2010 Richard Lincoln
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


""" Defines a map of class names to their module.
"""

dynamics_pkg_map = {
    "Element": "dynamics",
    "Model": "dynamics",
    "RotatingMachine": "dynamics.dynamics",
    "MetaBlockConOutput": "dynamics.dynamics",
    "AttributeBlockParameter": "dynamics.dynamics",
    "MetaBlock": "dynamics.dynamics",
    "BlockParameter": "dynamics.dynamics",
    "MetaBlockReference": "dynamics.dynamics",
    "ExcitationSystemLimiter": "dynamics.dynamics",
    "MetaBlockConnectivity": "dynamics.dynamics",
    "ProtectiveDevice": "dynamics.dynamics",
    "MetaBlockInput": "dynamics.dynamics",
    "SourceModels": "dynamics.dynamics",
    "MetaBlockOutputReference": "dynamics.dynamics",
    "MetaBlockOutput": "dynamics.dynamics",
    "MetaBlockParameter": "dynamics.dynamics",
    "BlockConnection": "dynamics.dynamics",
    "MetaBlockConInput": "dynamics.dynamics",
    "StaticVarDevice": "dynamics.dynamics",
    "MetaBlockConnection": "dynamics.dynamics",
    "BlockConnectivity": "dynamics.dynamics",
    "MetaBlockConSignal": "dynamics.dynamics",
    "Block": "dynamics.dynamics",
    "MetaBlockStateReference": "dynamics.dynamics",
    "AsynchronousMachine": "dynamics.dynamics",
    "TieToMeasurement": "dynamics.dynamics",
    "MetaBlockSignal": "dynamics.dynamics",
    "MetaBlockInputReference": "dynamics.dynamics",
    "MetaBlockParameterReference": "dynamics.dynamics",
    "MetaBlockConnectable": "dynamics.dynamics",
    "MetaBlockState": "dynamics.dynamics",
    "LoadStaticSystem": "dynamics.dynamics.loads",
    "LoadStaticOwner": "dynamics.dynamics.loads",
    "LoadStatic": "dynamics.dynamics.loads",
    "AggregateLoad": "dynamics.dynamics.loads",
    "LoadMotor": "dynamics.dynamics.loads",
    "LoadStaticBus": "dynamics.dynamics.loads",
    "LoadStaticZone": "dynamics.dynamics.loads",
    "LoadStaticArea": "dynamics.dynamics.loads",
    "ExcBAS": "dynamics.dynamics.excitation_systems",
    "ExcDC2A": "dynamics.dynamics.excitation_systems",
    "ExcSEXS": "dynamics.dynamics.excitation_systems",
    "ExcELIN2": "dynamics.dynamics.excitation_systems",
    "ExcAC4A": "dynamics.dynamics.excitation_systems",
    "ExcSK": "dynamics.dynamics.excitation_systems",
    "ExcAC2A": "dynamics.dynamics.excitation_systems",
    "ExcELIN1": "dynamics.dynamics.excitation_systems",
    "ExcST6B": "dynamics.dynamics.excitation_systems",
    "ExcST4B": "dynamics.dynamics.excitation_systems",
    "ExcWT3E": "dynamics.dynamics.excitation_systems",
    "ExcPIC": "dynamics.dynamics.excitation_systems",
    "ExcSK2": "dynamics.dynamics.excitation_systems",
    "ExcST2A": "dynamics.dynamics.excitation_systems",
    "ExcHU": "dynamics.dynamics.excitation_systems",
    "ExcREXS": "dynamics.dynamics.excitation_systems",
    "ExcST7B": "dynamics.dynamics.excitation_systems",
    "ExcAC1A": "dynamics.dynamics.excitation_systems",
    "ExcDC4B": "dynamics.dynamics.excitation_systems",
    "ExcDC1A": "dynamics.dynamics.excitation_systems",
    "ExcAC3A": "dynamics.dynamics.excitation_systems",
    "ExcAC6A": "dynamics.dynamics.excitation_systems",
    "ExcAC5A": "dynamics.dynamics.excitation_systems",
    "ExcST5B": "dynamics.dynamics.excitation_systems",
    "ExcSCRX": "dynamics.dynamics.excitation_systems",
    "ExcAC8B": "dynamics.dynamics.excitation_systems",
    "ExcWT2E": "dynamics.dynamics.excitation_systems",
    "ExcAC7B": "dynamics.dynamics.excitation_systems",
    "ExcWT4E": "dynamics.dynamics.excitation_systems",
    "ExcST1A": "dynamics.dynamics.excitation_systems",
    "ExcBBC": "dynamics.dynamics.excitation_systems",
    "ExcitationSystem": "dynamics.dynamics.excitation_systems",
    "ExcDC3A": "dynamics.dynamics.excitation_systems",
    "ExcST3A": "dynamics.dynamics.excitation_systems",
    "ExcCZ": "dynamics.dynamics.excitation_systems",
    "GovHydro3": "dynamics.dynamics.turbine_governors",
    "GovHydro2": "dynamics.dynamics.turbine_governors",
    "GovGAST": "dynamics.dynamics.turbine_governors",
    "GovWT1T": "dynamics.dynamics.turbine_governors",
    "TurbineGovernor": "dynamics.dynamics.turbine_governors",
    "GovWT2P": "dynamics.dynamics.turbine_governors",
    "GovHydroDD": "dynamics.dynamics.turbine_governors",
    "GovHydroWEH": "dynamics.dynamics.turbine_governors",
    "GovWT3T": "dynamics.dynamics.turbine_governors",
    "GovHydroPID": "dynamics.dynamics.turbine_governors",
    "GovHydro4": "dynamics.dynamics.turbine_governors",
    "GovDUM": "dynamics.dynamics.turbine_governors",
    "GovHydroWPID": "dynamics.dynamics.turbine_governors",
    "GovWT4P": "dynamics.dynamics.turbine_governors",
    "TLCFB1": "dynamics.dynamics.turbine_governors",
    "GovGASM": "dynamics.dynamics.turbine_governors",
    "GovHydroR": "dynamics.dynamics.turbine_governors",
    "GovSteamFV2": "dynamics.dynamics.turbine_governors",
    "GovRAV": "dynamics.dynamics.turbine_governors",
    "GovCT2": "dynamics.dynamics.turbine_governors",
    "GovSteam1": "dynamics.dynamics.turbine_governors",
    "GovSteamCC": "dynamics.dynamics.turbine_governors",
    "GovSteamSGO": "dynamics.dynamics.turbine_governors",
    "GovSteamFV3": "dynamics.dynamics.turbine_governors",
    "GovWT3P": "dynamics.dynamics.turbine_governors",
    "GovWT1P": "dynamics.dynamics.turbine_governors",
    "GovSteam0": "dynamics.dynamics.turbine_governors",
    "GovCT1": "dynamics.dynamics.turbine_governors",
    "GovWT2T": "dynamics.dynamics.turbine_governors",
    "GovHydro1": "dynamics.dynamics.turbine_governors",
    "GovHydroPID2": "dynamics.dynamics.turbine_governors",
    "GovWT4T": "dynamics.dynamics.turbine_governors",
    "GovSteamEU": "dynamics.dynamics.turbine_governors",
    "GovHydro0": "dynamics.dynamics.turbine_governors",
    "GovGASTWD": "dynamics.dynamics.turbine_governors",
    "GovGAST2": "dynamics.dynamics.turbine_governors",
    "PowerSystemStabilizer": "dynamics.dynamics.power_system_stabilizers",
    "PssIEEE4B": "dynamics.dynamics.power_system_stabilizers",
    "PssIEEE2B": "dynamics.dynamics.power_system_stabilizers",
    "PssSB4": "dynamics.dynamics.power_system_stabilizers",
    "PssSB": "dynamics.dynamics.power_system_stabilizers",
    "PssSK": "dynamics.dynamics.power_system_stabilizers",
    "PssPTIST3": "dynamics.dynamics.power_system_stabilizers",
    "PssIEEE1A": "dynamics.dynamics.power_system_stabilizers",
    "PssIEEE3B": "dynamics.dynamics.power_system_stabilizers",
    "PssWSCC": "dynamics.dynamics.power_system_stabilizers",
    "PssPTIST1": "dynamics.dynamics.power_system_stabilizers",
    "PssSH": "dynamics.dynamics.power_system_stabilizers",
    "GenSync": "dynamics.dynamics.generators",
    "GenLoad": "dynamics.dynamics.generators",
    "GenAsync": "dynamics.dynamics.generators",
    "GenEquiv": "dynamics.dynamics.generators",
    "VcompIEEE": "dynamics.dynamics.voltage_compensator",
    "VoltageCompensator": "dynamics.dynamics.voltage_compensator",
    "VcompCross": "dynamics.dynamics.voltage_compensator",
    "MotorAsync": "dynamics.dynamics.motors",
    "MechanicalLoad": "dynamics.dynamics.motors",
    "MechLoad1": "dynamics.dynamics.motors",
    "SynchronousMotorType": "dynamics.dynamics.motors",
    "MotorSync": "dynamics.dynamics.motors",
}
