#!/usr/bin/env python
#-*- coding:utf-8 -*-

###############################################################
# CLAM: Computational Linguistics Application Mediator
# -- CLAM Wrapper script for Text Statistics --
#       by Maarten van Gompel (proycon)
#       http://ilk.uvt.nl/~mvgompel
#       Induction for Linguistic Knowledge Research Group
#       Universiteit van Tilburg
#       
#       Licensed under GPLv3
#
###############################################################

#This is a test wrapper, meant to illustrate how easy it is to set
#up a wrapper script for your system using Python and the CLAM Client API.
#We make use of the XML configuration file that CLAM outputs, rather than 
#passing all parameters on the command line.

#This script will be called by CLAM and will run with the current working directory set to the specified project directory

#import some general python modules:
import sys
import os
import codecs
import re
import string

#import CLAM-specific modules. The CLAM API makes a lot of stuff easily accessible.
import clam.common.data
import clam.common.status



##########################################################################################################
#   Auxiliary functions (not using CLAM API at all, SKIP THIS if you're only interested in the wrapper script! )
#########################################################################################################



def crude_tokenizer(line):
    """This is a very crude tokenizer from pynlpl"""
    tokens = []
    buffer = ''
    for c in line.strip():
        if c == ' ' or c in string.punctuation:
            if buffer:
                tokens.append(buffer)
                buffer = ''
        else:
            buffer += c          
    if buffer: tokens.append(buffer)  
    return tokens


    
#########################################################################################################
#       MAIN WRAPPER
#########################################################################################################


if __name__ == "__main__":

    #this script takes three arguments from CLAM: $DATAFILE $STATUSFILE $OUTPUTDIRECTORY  (as configured at COMMAND= in the service configuration file)
    datafile = sys.argv[1]
    statusfile = sys.argv[2]
    outputdir = sys.argv[3]

    #Obtain all data from the CLAM system (passed in $DATAFILE (clam.xml))
    clamdata = clam.common.data.getclamdata(datafile)

    #You now have access to all data. A few properties at your disposition now are:
    # clamdata.system_id , clamdata.project, clamdata.user, clamdata.status , clamdata.parameters, clamdata.inputformats, clamdata.outputformats , clamdata.input , clamdata.output

    clam.common.status.write(statusfile, "Starting...")

    listinputfile = textinputfile = None

    for i, inputfile in enumerate(clamdata.input):
        #Update our status message to let CLAM know what we're doing
        clam.common.status.write(statusfile, "Processing " + os.path.basename(str(inputfile)) + "...", round((i/float(len(clamdata.input)))*100))
        #We need one of the metadata fields
#        encoding = inputfile.metadata['encoding']
            
        #Calling a function containing the actual core of this program (totally CLAM unaware).
        #In other scenarios, this could be where you invoke other scripts/programs through os.system()

        
        print >> sys.stderr, str(inputfile), " for loop"

        if inputfile.metadata.inputtemplate == 'textinput':
            textinputfile = str(inputfile)
        elif inputfile.metadata.inputtemplate == 'listinput':
            listinputfile = str(inputfile)
        print >> sys.stderr, textinputfile
        print >> sys.stderr, listinputfile
       
        if listinputfile and textinputfile:

            print >> sys.stderr, listinputfile, textinputfile
            os.system("perl /home/tgaustad/work/implicit_linguistics/list_comparison.pl -l " + listinputfile + " -i " + textinputfile + " > " + outputdir + os.path.basename(textinputfile) + '.spellcorrectlist') 
        
        #Write statistics output for this file
        #Note 1) The filenames must always correspond to what has been defined in PROFILES in the service configuration file!
        #Note 2) The output metadata will be generated by CLAM itself, so there's no need to do that here.
        
        
    #A nice status message to indicate we're done
    clam.common.status.write(statusfile, "Done",100) # status update

    sys.exit(0) #non-zero exit codes indicate an error and will be picked up by CLAM as such!
