#  ============================================================================
#
#  Copyright (C) 2007-2012 Conceptive Engineering bvba. All rights reserved.
#  www.conceptive.be / project-camelot@conceptive.be
#
#  This file is part of the Camelot Library.
#
#  This file may be used under the terms of the GNU General Public
#  License version 2.0 as published by the Free Software Foundation
#  and appearing in the file license.txt included in the packaging of
#  this file.  Please review this information to ensure GNU
#  General Public Licensing requirements will be met.
#
#  If you are unsure which license is appropriate for your use, please
#  visit www.python-camelot.com or contact project-camelot@conceptive.be
#
#  This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
#  WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#  For use of this library in commercial applications, please contact
#  project-camelot@conceptive.be
#
#  ============================================================================
import logging
logger = logging.getLogger('camelot.view.export.outlook')

"""Functions to send files by email using outlook

After http://win32com.goermezer.de/content/view/227/192/
"""

def open_html_in_outlook(html):
  
    try:
        import pythoncom
        import win32com.client
        pythoncom.CoInitialize()
        outlook_app = win32com.client.Dispatch("Outlook.Application")
    except Exception, e:
        """We're probably not running windows"""
        logger.warn('unable to launch Outlook', exc_info=e)
        return
      
    msg = outlook_app.CreateItem(0)
    #msg.BodyFormat=2
    msg.HTMLBody=html
    #msg.Subject=o_subject
    msg.Display(True)



