#  ============================================================================
#
#  Copyright (C) 2007-2013 Conceptive Engineering bvba. All rights reserved.
#  www.conceptive.be / info@conceptive.be
#
#  This file is part of the Camelot Library.
#
#  This file may be used under the terms of the GNU General Public
#  License version 2.0 as published by the Free Software Foundation
#  and appearing in the file license.txt included in the packaging of
#  this file.  Please review this information to ensure GNU
#  General Public Licensing requirements will be met.
#
#  If you are unsure which license is appropriate for your use, please
#  visit www.python-camelot.com or contact info@conceptive.be
#
#  This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
#  WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#  For use of this library in commercial applications, please contact
#  info@conceptive.be
#
#  ============================================================================

"""Encapsulates various ms office schemes"""

Office2003BlueStyle = {
  'SplitterDark' : '(21, 28, 171)',
  'SplitterLight' : '(129, 168, 226)',
  'BorderColor' : '(21, 28, 171)',
  'TextColor' : '(0, 0, 0)',
  'ButtonNormalBegin' : '(201, 223, 251)',
  'ButtonNormalMiddleBegin' : '(165, 196, 239)',
  'ButtonNormalMiddleEnd' : '(165, 196, 239)',
  'ButtonNormalEnd' : '(129, 168, 226)',
  'ButtonMouseOverBegin' : '(255, 253, 216)',
  'ButtonMouseOverMiddleBegin' : '(251, 222, 152)',
  'ButtonMouseOverMiddleEnd' : '(251, 222, 152)',
  'ButtonMouseOverEnd' : '(248, 194, 95)',
  'SelectedTextColor' : '(0, 0, 0)',
  'ButtonSelectedBegin' : '(251, 228, 144)',
  'ButtonSelectedMiddleBegin' : '(245, 190, 85)',
  'ButtonSelectedMiddleEnd' : '(245, 190, 85)',
  'ButtonSelectedEnd' : '(240, 153, 25)',
  'CaptionBegin' : '(201, 223, 251)',
  'CaptionEnd' : '(129, 168, 226)',
  'CaptionDescBegin' : '(201, 223, 251)',
  'CaptionDescEnd' : '(129, 168, 226)',
  'CaptionTextColor' : '(21, 28, 171)',
  'ContextMenuBackColor' : '(253, 250, 255)'
}

Office2003SilverStyle = {
  'SplitterDark' : '(150, 148, 178)',
  'SplitterLight' : '(223, 224, 234)',
  'BorderColor' : '(100, 97, 135)',
  'TextColor' : '(0, 0, 0)',
  'ButtonNormalBegin' : '(223, 224, 234)',
  'ButtonNormalMiddleBegin' : '(190, 190, 209)',
  'ButtonNormalMiddleEnd' : '(190, 190, 209)',
  'ButtonNormalEnd' : '(150, 148, 178)',
  'ButtonMouseOverBegin' : '(255, 253, 216)',
  'ButtonMouseOverMiddleBegin' : '(251, 222, 152)',
  'ButtonMouseOverMiddleEnd' : '(251, 222, 152)',
  'ButtonMouseOverEnd' : '(248, 194, 95)',
  'SelectedTextColor' : '(0, 0, 0)',
  'ButtonSelectedBegin' : '(251, 228, 144)',
  'ButtonSelectedMiddleBegin' : '(245, 190, 85)',
  'ButtonSelectedMiddleEnd' : '(245, 190, 85)',
  'ButtonSelectedEnd' : '(240, 153, 25)',
  'CaptionBegin' : '(223, 224, 234)',
  'CaptionEnd' : '(100, 97, 135)',
  'CaptionDescBegin' : '(223, 224, 234)',
  'CaptionDescEnd' : '(150, 148, 178)',
  'CaptionTextColor' : '(0, 0, 0)',
  'ContextMenuBackColor' : '(253, 250, 255)'
}

Office2003OliveStyle = {
  'SplitterDark' : '(182, 196, 144)',
  'SplitterLight' : '(233, 239, 205)',
  'BorderColor' : '(134, 161, 105)',
  'TextColor' : '(0, 0, 0)',
  'ButtonNormalBegin' : '(233, 239, 205)',
  'ButtonNormalMiddleBegin' : '(208, 218, 176)',
  'ButtonNormalMiddleEnd' : '(208, 218, 176)',
  'ButtonNormalEnd' : '(182, 196, 144)',
  'ButtonMouseOverBegin' : '(255, 253, 216)',
  'ButtonMouseOverMiddleBegin' : '(251, 222, 152)',
  'ButtonMouseOverMiddleEnd' : '(251, 222, 152)',
  'ButtonMouseOverEnd' : '(248, 194, 95)',
  'SelectedTextColor' : '(0, 0, 0)',
  'ButtonSelectedBegin' : '(251, 228, 144)',
  'ButtonSelectedMiddleBegin' : '(245, 190, 85)',
  'ButtonSelectedMiddleEnd' : '(245, 190, 85)',
  'ButtonSelectedEnd' : '(240, 153, 25)',
  'CaptionBegin' : '(233, 239, 205)',
  'CaptionEnd' : '(134, 161, 105)',
  'CaptionDescBegin' : '(233, 239, 205)',
  'CaptionDescEnd' : '(182, 196, 144)',
  'CaptionTextColor' : '(0, 0, 0)',
  'ContextMenuBackColor' : '(253, 250, 255)'
}

Office2007BlueStyle = {
  'SplitterDark' : '(192, 219, 255)',
  'SplitterLight' : '(227, 239, 255)',
  'BorderColor' : '(101, 147, 207)',
  'TextColor' : '(32, 77, 137)',
  'ButtonNormalBegin' : '(227, 239, 255)',
  'ButtonNormalMiddleBegin' : '(196, 221, 255)',
  'ButtonNormalMiddleEnd' : '(173, 209, 255)',
  'ButtonNormalEnd' : '(192, 219, 255)',
  'ButtonMouseOverBegin' : '(255, 254, 228)',
  'ButtonMouseOverMiddleBegin' : '(255, 232, 167)',
  'ButtonMouseOverMiddleEnd' : '(255, 215, 103)',
  'ButtonMouseOverEnd' : '(255, 230, 158)',
  'SelectedTextColor' : '(0, 0, 0)',
  'ButtonSelectedBegin' : '(255, 217, 170)',
  'ButtonSelectedMiddleBegin' : '(255, 187, 110)',
  'ButtonSelectedMiddleEnd' : '(255, 171, 63)',
  'ButtonSelectedEnd' : '(254, 225, 122)',
  'ButtonSelectedOverBegin' : '(255, 189, 105)',
  'ButtonSelectedOverMiddleBegin' : '(255, 172, 66)',
  'ButtonSelectedOverMiddleEnd' : '(251, 140, 60)',
  'ButtonSelectedOverEnd' : '(254, 211, 100)',
  'CaptionBegin' : '(227, 239, 255)',
  'CaptionEnd' : '(173, 209, 255)',
  'CaptionDescBegin' : '(227, 239, 255)',
  'CaptionDescEnd' : '(192, 219, 255)',
  'CaptionTextColor' : '(21, 66, 139)',
  'ContextMenuBackColor' : '(227, 239, 255)'
}

Office2007BlackStyle = {
  'SplitterDark' : '(199, 203, 209)',
  'SplitterLight' : '(219, 222, 226)',
  'BorderColor' : '(76, 83, 92)',
  'TextColor' : '(76, 83, 92)',
  'ButtonNormalBegin' : '(248, 248, 249)',
  'ButtonNormalMiddleBegin' : '(223, 226, 228)',
  'ButtonNormalMiddleEnd' : '(199, 203, 209)',
  'ButtonNormalEnd' : '(219, 222, 226)',
  'ButtonMouseOverBegin' : '(255, 254, 228)',
  'ButtonMouseOverMiddleBegin' : '(255, 232, 167)',
  'ButtonMouseOverMiddleEnd' : '(255, 215, 103)',
  'ButtonMouseOverEnd' : '(255, 230, 158)',
  'SelectedTextColor' : '(0, 0, 0)',
  'ButtonSelectedBegin' : '(255, 217, 170)',
  'ButtonSelectedMiddleBegin' : '(255, 187, 110)',
  'ButtonSelectedMiddleEnd' : '(255, 171, 63)',
  'ButtonSelectedEnd' : '(254, 225, 122)',
  'CaptionBegin' : '(240, 241, 242)',
  'CaptionEnd' : '(189, 193, 200)',
  'CaptionDescBegin' : '(240, 241, 242)',
  'CaptionDescEnd' : '(189, 193, 200)',
  'CaptionTextColor' : '(0, 0, 0)',
  'ContextMenuBackColor' : '(248, 248, 249)'
}

Office2007SilverStyle = {
  'SplitterDark' : '(119, 118, 151)',
  'SplitterLight' : '(168, 167, 191)',
  'BorderColor' : '(111, 112, 116)',
  'TextColor' : '(111, 112, 116)',
  'ButtonNormalBegin' : '(235, 238, 250)',
  'ButtonNormalMiddleBegin' : '(214, 218, 228)',
  'ButtonNormalMiddleEnd' : '(197, 199, 204)',
  'ButtonNormalEnd' : '(212, 216, 226)',
  'ButtonMouseOverBegin' : '(255, 254, 228)',
  'ButtonMouseOverMiddleBegin' : '(255, 232, 167)',
  'ButtonMouseOverMiddleEnd' : '(255, 215, 103)',
  'ButtonMouseOverEnd' : '(255, 230, 158)',
  'SelectedTextColor' : '(0, 0, 0)',
  'ButtonSelectedBegin' : '(255, 217, 170)',
  'ButtonSelectedMiddleBegin' : '(255, 187, 110)',
  'ButtonSelectedMiddleEnd' : '(255, 171, 63)',
  'ButtonSelectedEnd' : '(254, 225, 122)',
  'CaptionBegin' : '(246, 247, 248)',
  'CaptionEnd' : '(218, 223, 230)',
  'CaptionDescBegin' : '(246, 247, 248)',
  'CaptionDescEnd' : '(218, 223, 230)',
  'CaptionTextColor' : '(0, 0, 0)',
  'ContextMenuBackColor' : '(235, 238, 250)'
}

class Scheme(object):
    def __init__(self, styledict=Office2007BlueStyle):
        self.styledict = styledict

    def color(self, r, g, b):
        return 'rgb(%s, %s, %s)' % (r, g, b)

    def bordercolor(self):
        return 'rgb%(BorderColor)s' % self.styledict

    def textcolor(self):
        return 'rgb%(TextColor)s' % self.styledict

    def selectedcolor(self):
        return 'rgb%(SelectedTextColor)s' % self.styledict

    def captiontextcolor(self):
        return 'rgb%(CaptionTextColor)s' % self.styledict

    def twocolorgradient(self, rgb1, rgb2):
        s = 'qlineargradient(spread:pad, ' \
            'x1:0.5, y1:0, x2:0.5, y2:1, ' \
            'stop:0 rgba%s, 255), ' \
            'stop:1 rgba%s, 255))' % (rgb1, rgb2)

        return s

    def fourcolorgradient(self, rgb1, rgb2, rgb3, rgb4):
        s = 'qlineargradient(spread:pad, ' \
            'x1:0.5, y1:0, x2:0.5, y2:1, ' \
            'stop:0 rgba%s, 255), ' \
            'stop:0.4 rgba%s, 255), ' \
            'stop:0.401 rgba%s, 255), ' \
            'stop:1 rgba%s, 255))' % (rgb1, rgb2, rgb3, rgb4)

        return s

    def normalbackground(self):
        rgb1 = self.styledict['ButtonNormalBegin'].rstrip(')')
        rgb2 = self.styledict['ButtonNormalMiddleBegin'].rstrip(')')
        rgb3 = self.styledict['ButtonNormalMiddleEnd'].rstrip(')')
        rgb4 = self.styledict['ButtonNormalEnd'].rstrip(')')

        return self.fourcolorgradient(rgb1, rgb2, rgb3, rgb4)

    def hoveredbackground(self):
        rgb1 = self.styledict['ButtonMouseOverBegin'].rstrip(')')
        rgb2 = self.styledict['ButtonMouseOverMiddleBegin'].rstrip(')')
        rgb3 = self.styledict['ButtonMouseOverMiddleEnd'].rstrip(')')
        rgb4 = self.styledict['ButtonMouseOverEnd'].rstrip(')')

        return self.fourcolorgradient(rgb1, rgb2, rgb3, rgb4)

    def selectedbackground(self, inverted=False):
        if inverted:
            rgb1 = self.styledict['ButtonSelectedOverBegin'].rstrip(')')
            rgb2 = self.styledict['ButtonSelectedOverMiddleBegin'].rstrip(')')
            rgb3 = self.styledict['ButtonSelectedOverMiddleEnd'].rstrip(')')
            rgb4 = self.styledict['ButtonSelectedOverEnd'].rstrip(')')
        else:
            rgb1 = self.styledict['ButtonSelectedBegin'].rstrip(')')
            rgb2 = self.styledict['ButtonSelectedMiddleBegin'].rstrip(')')
            rgb3 = self.styledict['ButtonSelectedMiddleEnd'].rstrip(')')
            rgb4 = self.styledict['ButtonSelectedEnd'].rstrip(')')

        return self.fourcolorgradient(rgb1, rgb2, rgb3, rgb4)

    def captionbackground(self):
        rgb1 = self.styledict['CaptionBegin'].rstrip(')')
        rgb2 = self.styledict['CaptionEnd'].rstrip(')')

        return self.twocolorgradient(rgb1, rgb2)

scheme = Scheme()
defaultUI = Office2007BlueStyle




