import sys

__input_file = None
__output_file = None

class PrintHook:
	def __init__(self, output_file):
		self.file_stdout = output_file
		self.real_stdout = sys.__stdout__

	def write(self, text):
		self.file_stdout.write(text)
		self.real_stdout.write(text)

	def __getattr__(self, name):
		return self.real_stdout.__getattr__(name)

def load_input(in_filename):
	global __input_file, __output_file

	__input_file = open(in_filename)
	__output_file = open(in_filename.replace('.in', '.out'), 'w')
	sys.stdout = PrintHook(__output_file)

def read_input(*lines):
	global __input_file

	if __input_file is None:
		if len(sys.argv) < 2:
			raise ValueError('Must specify input file with load_input() or on command line')
		load_input(sys.argv[1])

	inputs = []
	for line in lines:
		formats = line.split()
		if len(formats) == 1 and '[' not in formats[0]:
			data = [__input_file.readline().strip()]
		else:
			data = __input_file.readline().split()

		for i, format in enumerate(formats):
			if format[0] == 's': converter = str
			if format[0] == 'i': converter = int
			if format[0] == 'f': converter = float

			if '[' in format:
				data_list = map(converter, data[i:])
				if '[<]' in format: data_list.sort()
				if '[>]' in format: data_list.sort(reverse = True)
				inputs += [data_list]
			else:
				inputs += [converter(data[i])]

	return inputs if len(inputs) > 1 else inputs[0]