import sys

__input_file = None
__output_file = None

class PrintHook:
	def __init__(self, output_file):
		self.file_stdout = output_file
		self.real_stdout = sys.__stdout__

	def write(self, text):
		self.file_stdout.write(text)
		self.real_stdout.write(text)

	def __getattr__(self, name):
		return self.real_stdout.__getattr__(name)

def load_input(in_filename):
	global __input_file, __output_file

	__input_file = open(in_filename)
	out_filename = in_filename.replace('.in', '') + '.out'
	__output_file = open(out_filename, 'w')
	sys.stdout = PrintHook(__output_file)

def read_input(*lines):
	global __input_file

	if __input_file is None:
		if len(sys.argv) < 2:
			raise ValueError('Must specify input file with load_input() or on command line')
		load_input(sys.argv[1])

	inputs, repeats = [], 1
	for line in lines:
		if line == '':
			__input_file.readline()
			continue
		elif type(line) is int:
			repeats = line
		else:
			formats = line.split()
			
			new_inputs = []
			next_repeats = 1
			for repeat in range(repeats):
				if len(formats) == 1 and '[' not in formats[0]:
					data = [__input_file.readline().strip()]
				else:
					data = __input_file.readline().split()

				for i, format in enumerate(formats):
					if format == 'i->':
						next_repeats = int(data[i])
						new_inputs += [next_repeats]
						continue

					if 's' in format: a_converter = str
					if 'i' in format: a_converter = int
					if 'f' in format: a_converter = float
					if '{' in format:
						converter = lambda x: map(a_converter, list(x))
					else:
						converter = a_converter

					if '[' in format:
						data_list = map(converter, data[i:])
						if '[<]' in format: data_list.sort()
						if '[>]' in format: data_list.sort(reverse = True)
						new_inputs += [data_list]
					else:
						new_inputs += [converter(data[i])]

			if repeats > 1:
				inputs += [new_inputs]
			else:
				inputs += new_inputs

			repeats = next_repeats

	return inputs if len(inputs) > 1 else inputs[0]