#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Copyright 2011-2013 Codernity (http://codernity.com)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from setuptools import setup
import os


def get_meta(inc, name):
    import re
    return eval(re.search(r'(?:%s)\s*=\s*(.*)' % name, inc).group(1))


with open(os.path.join("CodernityDBHTTP", '__init__.py'), 'r') as _init:
    _init_d = _init.read()

__version__ = get_meta(_init_d, '__version__')
__license__ = get_meta(_init_d, '__license__')


with open('README') as f:
    L_DESCR = f.read()


setup(name='CodernityDB-HTTP',
      version=__version__,
      description="HTTP server version of CodernityDB",
      long_description=L_DESCR,
      author='Codernity',
      author_email='contact@codernity.com',
      url='http://labs.codernity.com/codernitydb-http',
      packages=['CodernityDBHTTP'],
      install_requires=["CodernityDB"],
      package_data={'CodernityDBHTTP': [
                    'interface/*.*',
                    'interface/images/*',
                    'interface/scripts/*.*',
                    'interface/scripts/lib/*.*',
                    'interface/scripts/lib/codemirror/*',
                    'interface/bootstrap/*.*',
                    'interface/bootstrap/js/*',
                    'interface/bootstrap/img/*',
                    'interface/bootstrap/css/*']},
      entry_points={
      'console_scripts':
          ['cdb_startserver = CodernityDBHTTP.server:run']
      },
      license=__license__,
      classifiers=[
      "License :: OSI Approved :: Apache Software License",
      "Programming Language :: Python :: 2.6",
      "Programming Language :: Python :: 2.7",
      "Operating System :: MacOS :: MacOS X",
      "Operating System :: POSIX",
      "Operating System :: Microsoft :: Windows",
      "Operating System :: OS Independent",
      "Topic :: Internet",
      "Topic :: Database",
      "Topic :: Software Development",
      "Intended Audience :: Developers",
      "Development Status :: 4 - Beta"])
