#!/usr/bin/env python
# -*- coding: utf-8 -*-

# CAVEAT UTILITOR
#
# This file was automatically generated by Grako.
#
#    https://pypi.python.org/pypi/grako/
#
# Any changes you make to it will be overwritten the next time
# the file is generated.


from __future__ import print_function, division, absolute_import, unicode_literals
from grako.parsing import graken, Parser


__version__ = (2014, 10, 10, 21, 11, 17, 4)

__all__ = [
    'en_wiktionaryParser',
    'en_wiktionarySemantics',
    'main'
]


class en_wiktionaryParser(Parser):
    def __init__(self, whitespace='', nameguard=True, **kwargs):
        super(en_wiktionaryParser, self).__init__(
            whitespace=whitespace,
            nameguard=nameguard,
            **kwargs
        )

    @graken()
    def _left_bracket_(self):
        self._token('[')

    @graken()
    def _right_bracket_(self):
        self._token(']')

    @graken()
    def _left_brace_(self):
        self._token('{')

    @graken()
    def _right_brace_(self):
        self._token('}')

    @graken()
    def _left_brackets_(self):
        self._token('[[')

    @graken()
    def _right_brackets_(self):
        self._token(']]')

    @graken()
    def _left_braces_(self):
        self._token('{{')

    @graken()
    def _right_braces_(self):
        self._token('}}')

    @graken()
    def _left_paren_(self):
        self._token('(')

    @graken()
    def _right_paren_(self):
        self._token(')')

    @graken()
    def _hash_char_(self):
        self._token('#')

    @graken()
    def _vertical_bar_(self):
        self._token('|')

    @graken()
    def _equals_(self):
        self._token('=')

    @graken()
    def _bullet_(self):
        self._token('*')

    @graken()
    def _colon_(self):
        self._token(':')

    @graken()
    def _comma_(self):
        self._token(',')

    @graken()
    def _semicolon_(self):
        self._token(';')

    @graken()
    def _slash_(self):
        self._token('/')

    @graken()
    def _dash_(self):
        with self._choice():
            with self._option():
                self._token('-')
            with self._option():
                self._token('—')
            with self._option():
                self._token('–')
            self._error('expecting one of: - – —')

    @graken()
    def _plus_sign_(self):
        self._token('+')

    @graken()
    def _single_left_bracket_(self):
        self._left_bracket_()
        with self._ifnot():
            self._left_bracket_()

    @graken()
    def _single_right_bracket_(self):
        self._right_bracket_()
        with self._ifnot():
            self._right_bracket_()

    @graken()
    def _single_left_brace_(self):
        self._left_brace_()
        with self._ifnot():
            self._left_brace_()

    @graken()
    def _single_right_brace_(self):
        self._right_brace_()
        with self._ifnot():
            self._right_brace_()

    @graken()
    def _SP_(self):
        self._pattern(r'[ \t]*')

    @graken()
    def _NL_(self):
        self._pattern(r'\n')

    @graken()
    def _WS_(self):
        self._pattern(r'[ \t\n]*')

    @graken()
    def _term_(self):
        self._pattern(r'[^\[\]{}<>|:=\n]+')

    @graken()
    def _term_or_punct_(self):
        self._pattern(r'[^\[\]{}|\n]+')

    @graken()
    def _comment_(self):
        self._pattern(r'<!--(.|\n)+?-->')

    @graken()
    def _html_tag_(self):
        self._pattern(r'<[^>]+?>')

    @graken()
    def _one_line_text_(self):
        with self._choice():
            with self._option():
                self._term_or_punct_()
                self.ast['@'] = self.last_node
            with self._option():
                self._single_left_bracket_()
                self.ast['@'] = self.last_node
            with self._option():
                self._single_right_bracket_()
                self.ast['@'] = self.last_node
            with self._option():
                self._single_left_brace_()
                self.ast['@'] = self.last_node
            with self._option():
                self._single_right_brace_()
                self.ast['@'] = self.last_node
            self._error('no available options')

    @graken()
    def _one_line_text_without_templates_(self):
        self._pattern(r'[^{}\n]*')

    @graken()
    def _text_(self):
        with self._choice():
            with self._option():
                self._one_line_text_()
                self.ast['@'] = self.last_node
            with self._option():
                self._NL_()
                self.ast['@'] = self.last_node
            self._error('no available options')

    @graken()
    def _image_(self):
        with self._choice():
            with self._option():
                self._left_brackets_()
                self._WS_()
                self._token('Image:')
                self._term_()
                self.ast['filename'] = self.last_node

                def block1():
                    self._vertical_bar_()
                    self._wikitext_()
                self._closure(block1)
                self._WS_()
                self._right_brackets_()
            with self._option():
                with self._optional():
                    self._vertical_bar_()
                    with self._optional():
                        self._SP_()
                self._token('Bild')
                with self._optional():
                    self._SP_()
                    self._pattern(r'[0-9]+')
                self._equals_()
                self._term_()
                self.ast['filename'] = self.last_node
                self._vertical_bar_()
                self._wikitext_()
                with self._optional():
                    self._right_braces_()
            self._error('no available options')

        self.ast._define(
            ['filename'],
            []
        )

    @graken()
    def _template_arg_(self):
        with self._optional():
            self._term_()
            self.ast['key'] = self.last_node
            self._WS_()
            self._equals_()
        self._WS_()
        self._wikitext_()
        self.ast['value'] = self.last_node

        self.ast._define(
            ['key', 'value'],
            []
        )

    @graken()
    def _template_args_(self):

        def block0():
            self._WS_()
            self._vertical_bar_()
            self._WS_()
            self._template_arg_()
            self.ast.setlist('@', self.last_node)
        self._positive_closure(block0)

    @graken()
    def _template_args_1_(self):
        self._WS_()
        self._vertical_bar_()
        self._WS_()
        self._wikitext_()
        self.ast['value'] = self.last_node

        def block1():
            self._vertical_bar_()
            self._wikitext_()
        self._closure(block1)

        self.ast._define(
            ['value'],
            []
        )

    @graken()
    def _template_(self):
        self._left_braces_()
        self._WS_()
        self._term_()
        self.ast['name'] = self.last_node
        with self._optional():
            self._template_args_()
            self.ast['args'] = self.last_node
        self._right_braces_()

        self.ast._define(
            ['name', 'args'],
            []
        )

    @graken()
    def _text_with_links_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._wiki_link_()
                with self._option():
                    self._text_()
                self._error('no available options')
        self._positive_closure(block0)

    @graken()
    def _one_line_text_with_links_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._wiki_link_()
                with self._option():
                    self._one_line_text_()
                self._error('no available options')
        self._positive_closure(block0)

    @graken()
    def _one_line_wikitext_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._template_()
                with self._option():
                    self._wiki_link_()
                with self._option():
                    self._external_link_()
                with self._option():
                    self._one_line_text_()
                self._error('no available options')
        self._positive_closure(block0)

    @graken()
    def _wikitext_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._template_()
                with self._option():
                    self._wiki_link_()
                with self._option():
                    self._external_link_()
                with self._option():
                    self._text_()
                self._error('no available options')
        self._positive_closure(block0)

    @graken()
    def _template_NS_(self):
        self._pattern(r'\{\{[^}]+\}\}')

    @graken()
    def _template_args_NS_(self):
        self._WS_()
        self._vertical_bar_()
        self._term_()

    @graken()
    def _wiki_link_NS_(self):
        self._pattern(r'\[\[[^]]+\]\]')

    @graken()
    def _text_with_links_NS_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._wiki_link_NS_()
                with self._option():
                    self._text_()
                self._error('no available options')
        self._positive_closure(block0)

    @graken()
    def _one_line_wikitext_NS_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._template_NS_()
                with self._option():
                    self._one_line_text_without_templates_()
                self._error('no available options')
        self._positive_closure(block0)

    @graken()
    def _wikitext_NS_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._template_NS_()
                with self._option():
                    self._wiki_link_NS_()
                with self._option():
                    self._external_link_()
                with self._option():
                    self._text_()
                self._error('no available options')
        self._positive_closure(block0)

    @graken()
    def _wiki_link_(self):
        self._left_brackets_()
        with self._optional():
            self._term_()
            self.ast['site'] = self.last_node
            self._colon_()
        self._term_()
        self.ast['target'] = self.last_node
        with self._optional():
            self._vertical_bar_()
            self._term_()
            self.ast['text'] = self.last_node
        self._right_brackets_()

        self.ast._define(
            ['site', 'target', 'text'],
            []
        )

    @graken()
    def _linktext_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._term_()
                    self.ast.setlist('@', self.last_node)
                with self._option():
                    self._html_tag_()
                with self._option():
                    self._NL_()
                with self._option():
                    self._colon_()
                    self.ast.setlist('@', self.last_node)
                with self._option():
                    self._equals_()
                    self.ast.setlist('@', self.last_node)
                self._error('no available options')
        self._positive_closure(block0)

    @graken()
    def _urlpath_(self):
        self._pattern(r'[^ \[\]{}<>|]+')

    @graken()
    def _url_(self):
        self._term_()
        self.ast['schema'] = self.last_node
        self._colon_()
        self._urlpath_()
        self.ast['path'] = self.last_node

        self.ast._define(
            ['schema', 'path'],
            []
        )

    @graken()
    def _external_link_(self):
        self._left_bracket_()
        self._url_()
        self.ast['url'] = self.last_node
        self._WS_()
        with self._optional():
            self._linktext_()
            self.ast['text'] = self.last_node
        self._right_bracket_()

        self.ast._define(
            ['url', 'text'],
            []
        )

    @graken()
    def _translation_name_(self):
        with self._choice():
            with self._option():
                self._token('t-simple')
            with self._option():
                self._token('t+')
            with self._option():
                self._token('t-')
            with self._option():
                self._token('t0')
            with self._option():
                self._token('tø')
            with self._option():
                self._token('t')
            self._error('expecting one of: t t+ t- t-simple t0 tø')

    @graken()
    def _translation_template_(self):
        self._left_braces_()
        self._WS_()
        self._translation_name_()
        self._WS_()
        self._vertical_bar_()
        self._WS_()
        self._term_()
        self.ast['language'] = self.last_node
        self._WS_()
        self._template_args_1_()
        self.ast['arg'] = self.last_node
        self._right_braces_()

        self.ast._define(
            ['language', 'arg'],
            []
        )

    @graken()
    def _sensetrans_top_template_(self):
        self._left_braces_()
        self._WS_()
        self._token('trans-top')
        self._WS_()
        self._vertical_bar_()
        self._WS_()
        self._text_with_links_()
        self.ast['sense'] = self.last_node
        self._WS_()
        self._right_braces_()

        self.ast._define(
            ['sense'],
            []
        )

    @graken()
    def _checktrans_top_template_(self):
        self._left_braces_()
        self._WS_()
        self._token('checktrans-top')
        self._WS_()
        self._right_braces_()

    @graken()
    def _ttbc_template_(self):
        self._left_braces_()
        self._token('ttbc')
        self._vertical_bar_()
        self._term_()
        self._right_braces_()

    @graken()
    def _translation_entry_(self):
        self._bullet_()
        self._SP_()

        def block0():
            with self._choice():
                with self._option():
                    self._term_or_punct_()
                with self._option():
                    self._ttbc_template_()
                    self._colon_()
                self._error('no available options')
        self._closure(block0)
        self._SP_()

        def block2():
            self._translation_template_()
            self.ast.setlist('translations', self.last_node)
            self._one_line_text_without_templates_()
        self._closure(block2)
        self._NL_()

        self.ast._define(
            [],
            ['translations']
        )

    @graken()
    def _translation_content_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._trans_mid_template_()
                with self._option():
                    self._translation_entry_()
                    self.ast.setlist('entries', self.last_node)
                with self._option():
                    self._WS_()
                self._error('no available options')
        self._positive_closure(block0)

        self.ast._define(
            [],
            ['entries']
        )

    @graken()
    def _trans_top_template_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._checktrans_top_template_()
                    self.ast['checktrans'] = self.last_node
                with self._option():
                    self._sensetrans_top_template_()
                    self.ast['sensetrans'] = self.last_node
                self._error('no available options')
        self._closure(block0)

        self.ast._define(
            ['checktrans', 'sensetrans'],
            []
        )

    @graken()
    def _trans_mid_template_(self):
        self._left_braces_()
        self._WS_()
        self._token('trans-mid')
        self._WS_()
        self._right_braces_()

    @graken()
    def _trans_bottom_template_(self):
        self._left_braces_()
        self._WS_()
        self._token('trans-bottom')
        self._WS_()
        self._right_braces_()

    @graken()
    def _translation_block_(self):
        self._trans_top_template_()
        self.ast['top'] = self.last_node
        self._WS_()
        self._translation_content_()
        self.ast['translations'] = self.last_node
        self._WS_()
        self._trans_bottom_template_()
        self._WS_()
        self._cut()

        self.ast._define(
            ['top', 'translations'],
            []
        )

    @graken()
    def _translation_section_(self):

        def block0():
            self._translation_block_()
            self.ast.setlist('blocks', self.last_node)
        self._closure(block0)

        self.ast._define(
            [],
            ['blocks']
        )

    @graken()
    def _link_template_name_(self):
        with self._choice():
            with self._option():
                self._token('term/t')
            with self._option():
                self._token('term')
            with self._option():
                self._token('l')
            with self._option():
                self._token('ja-l')
            with self._option():
                self._token('ko-inline')
            with self._option():
                self._token('blend')
            with self._option():
                self._token('borrowing')
            with self._option():
                self._token('back-form')
            with self._option():
                self._token('calque')
            with self._option():
                self._token('clipping')
            with self._option():
                self._token('compound')
            with self._option():
                self._token('confix')
            with self._option():
                self._token('-er')
            with self._option():
                self._token('etycomp')
            with self._option():
                self._token('prefix')
            with self._option():
                self._token('suffix')
            self._error('expecting one of: -er back-form blend borrowing calque clipping compound confix etycomp ja-l ko-inline l prefix suffix term term/t')

    @graken()
    def _link_template_(self):
        self._left_braces_()
        self._WS_()
        self._link_template_name_()
        self.ast['linktype'] = self.last_node

        def block1():
            self._slash_()
            self._term_()
            self.ast.setlist('subtypes', self.last_node)
        self._closure(block1)
        self._template_args_()
        self.ast['args'] = self.last_node
        self._right_braces_()

        self.ast._define(
            ['linktype', 'args'],
            ['subtypes']
        )

    @graken()
    def _etyl_template_(self):
        self._left_braces_()
        self._WS_()
        self._token('etyl')
        self._WS_()
        self._vertical_bar_()
        self._term_()
        self.ast['language'] = self.last_node
        self._WS_()
        self._template_args_NS_()
        self._right_braces_()

        self.ast._define(
            ['language'],
            []
        )

    @graken()
    def _etyl_link_(self):
        with self._choice():
            with self._option():
                self._link_template_()
            with self._option():
                self._wiki_link_()
            self._error('no available options')

    @graken()
    def _etyl_template_and_link_(self):
        self._etyl_template_()
        self.ast['etyl'] = self.last_node
        self._WS_()
        self._one_line_text_()
        self._etyl_link_()
        self.ast['link'] = self.last_node

        self.ast._define(
            ['etyl', 'link'],
            []
        )

    @graken()
    def _link_entry_(self):
        self._bullet_()
        self._SP_()
        with self._optional():
            self._sense_template_()
            self.ast['sense'] = self.last_node
        self._SP_()

        def block1():
            with self._choice():
                with self._option():
                    self._link_template_()
                    self.ast.setlist('links', self.last_node)
                with self._option():
                    self._wiki_link_()
                    self.ast.setlist('links', self.last_node)
                with self._option():
                    self._template_NS_()
                with self._option():
                    self._external_link_()
                with self._option():
                    self._one_line_text_()
                self._error('no available options')
        self._positive_closure(block1)

        self._NL_()
        self._cut()

        self.ast._define(
            ['sense'],
            ['links']
        )

    @graken()
    def _sense_template_(self):
        self._left_braces_()
        self._WS_()
        self._token('sense')
        self._WS_()
        self._vertical_bar_()
        self._text_with_links_()
        self.ast['@'] = self.last_node
        self._right_braces_()

    @graken()
    def _link_section_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._link_entry_()
                    self.ast.setlist('entries', self.last_node)
                with self._option():
                    self._template_NS_()
                with self._option():
                    self._WS_()
                self._error('no available options')
        self._positive_closure(block0)

        self.ast._define(
            [],
            ['entries']
        )

    @graken()
    def _etymology_section_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._etyl_template_and_link_()
                    self.ast.setlist('etym', self.last_node)
                with self._option():
                    self._link_template_()
                    self.ast.setlist('etym', self.last_node)
                with self._option():
                    self._template_NS_()
                with self._option():
                    self._wiki_link_NS_()
                with self._option():
                    self._external_link_()
                with self._option():
                    self._text_()
                self._error('no available options')
        self._positive_closure(block0)

        self.ast._define(
            [],
            ['etym']
        )

    @graken()
    def _list_chars_(self):
        self._pattern(r'[#*:]+')

    @graken()
    def _defn_line_(self):
        self._hash_char_()
        with self._ifnot():
            self._bullet_()
        self._SP_()
        self._one_line_wikitext_()
        self.ast['@'] = self.last_node
        self._NL_()
        self._WS_()

    @graken()
    def _defn_details_(self):
        self._hash_char_()
        self._list_chars_()
        self._SP_()
        self._one_line_wikitext_()
        self.ast['@'] = self.last_node
        self._NL_()
        self._WS_()

    @graken()
    def _definition_(self):
        self._defn_line_()
        self.ast['@'] = self.last_node

        def block1():
            self._defn_details_()
        self._closure(block1)
        self._cut()

    @graken()
    def _definition_section_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._template_NS_()
                with self._option():
                    self._image_()
                with self._option():
                    self._WS_()
                self._error('no available options')
        self._closure(block0)

        def block2():
            with self._choice():
                with self._option():
                    self._definition_()
                    self.ast.setlist('defns', self.last_node)
                with self._option():
                    self._one_line_wikitext_NS_()
                    self._NL_()
                self._error('no available options')
        self._closure(block2)

        self.ast._define(
            [],
            ['defns']
        )


class en_wiktionarySemantics(object):
    def left_bracket(self, ast):
        return ast

    def right_bracket(self, ast):
        return ast

    def left_brace(self, ast):
        return ast

    def right_brace(self, ast):
        return ast

    def left_brackets(self, ast):
        return ast

    def right_brackets(self, ast):
        return ast

    def left_braces(self, ast):
        return ast

    def right_braces(self, ast):
        return ast

    def left_paren(self, ast):
        return ast

    def right_paren(self, ast):
        return ast

    def hash_char(self, ast):
        return ast

    def vertical_bar(self, ast):
        return ast

    def equals(self, ast):
        return ast

    def bullet(self, ast):
        return ast

    def colon(self, ast):
        return ast

    def comma(self, ast):
        return ast

    def semicolon(self, ast):
        return ast

    def slash(self, ast):
        return ast

    def dash(self, ast):
        return ast

    def plus_sign(self, ast):
        return ast

    def single_left_bracket(self, ast):
        return ast

    def single_right_bracket(self, ast):
        return ast

    def single_left_brace(self, ast):
        return ast

    def single_right_brace(self, ast):
        return ast

    def SP(self, ast):
        return ast

    def NL(self, ast):
        return ast

    def WS(self, ast):
        return ast

    def term(self, ast):
        return ast

    def term_or_punct(self, ast):
        return ast

    def comment(self, ast):
        return ast

    def html_tag(self, ast):
        return ast

    def one_line_text(self, ast):
        return ast

    def one_line_text_without_templates(self, ast):
        return ast

    def text(self, ast):
        return ast

    def image(self, ast):
        return ast

    def template_arg(self, ast):
        return ast

    def template_args(self, ast):
        return ast

    def template_args_1(self, ast):
        return ast

    def template(self, ast):
        return ast

    def text_with_links(self, ast):
        return ast

    def one_line_text_with_links(self, ast):
        return ast

    def one_line_wikitext(self, ast):
        return ast

    def wikitext(self, ast):
        return ast

    def template_NS(self, ast):
        return ast

    def template_args_NS(self, ast):
        return ast

    def wiki_link_NS(self, ast):
        return ast

    def text_with_links_NS(self, ast):
        return ast

    def one_line_wikitext_NS(self, ast):
        return ast

    def wikitext_NS(self, ast):
        return ast

    def wiki_link(self, ast):
        return ast

    def linktext(self, ast):
        return ast

    def urlpath(self, ast):
        return ast

    def url(self, ast):
        return ast

    def external_link(self, ast):
        return ast

    def translation_name(self, ast):
        return ast

    def translation_template(self, ast):
        return ast

    def sensetrans_top_template(self, ast):
        return ast

    def checktrans_top_template(self, ast):
        return ast

    def ttbc_template(self, ast):
        return ast

    def translation_entry(self, ast):
        return ast

    def translation_content(self, ast):
        return ast

    def trans_top_template(self, ast):
        return ast

    def trans_mid_template(self, ast):
        return ast

    def trans_bottom_template(self, ast):
        return ast

    def translation_block(self, ast):
        return ast

    def translation_section(self, ast):
        return ast

    def link_template_name(self, ast):
        return ast

    def link_template(self, ast):
        return ast

    def etyl_template(self, ast):
        return ast

    def etyl_link(self, ast):
        return ast

    def etyl_template_and_link(self, ast):
        return ast

    def link_entry(self, ast):
        return ast

    def sense_template(self, ast):
        return ast

    def link_section(self, ast):
        return ast

    def etymology_section(self, ast):
        return ast

    def list_chars(self, ast):
        return ast

    def defn_line(self, ast):
        return ast

    def defn_details(self, ast):
        return ast

    def definition(self, ast):
        return ast

    def definition_section(self, ast):
        return ast


def main(filename, startrule, trace=False, whitespace=None):
    import json
    with open(filename) as f:
        text = f.read()
    parser = en_wiktionaryParser(parseinfo=False)
    ast = parser.parse(
        text,
        startrule,
        filename=filename,
        trace=trace,
        whitespace=whitespace)
    print('AST:')
    print(ast)
    print()
    print('JSON:')
    print(json.dumps(ast, indent=2))
    print()

if __name__ == '__main__':
    import argparse
    import string
    import sys

    class ListRules(argparse.Action):
        def __call__(self, parser, namespace, values, option_string):
            print('Rules:')
            for r in en_wiktionaryParser.rule_list():
                print(r)
            print()
            sys.exit(0)

    parser = argparse.ArgumentParser(description="Simple parser for en_wiktionary.")
    parser.add_argument('-l', '--list', action=ListRules, nargs=0,
                        help="list all rules and exit")
    parser.add_argument('-t', '--trace', action='store_true',
                        help="output trace information")
    parser.add_argument('-w', '--whitespace', type=str, default=string.whitespace,
                        help="whitespace specification")
    parser.add_argument('file', metavar="FILE", help="the input file to parse")
    parser.add_argument('startrule', metavar="STARTRULE",
                        help="the start rule for parsing")
    args = parser.parse_args()

    main(
        args.file,
        args.startrule,
        trace=args.trace,
        whitespace=args.whitespace
    )
