import sys
sys.path.append('..')
import itertools
import dagpype
import re


def _grab_doc(wh):
    doc = eval('dagpype.%s.__doc__' % wh)
    if not doc:
        print('no doc for', wh)
        return
    new_doc = ''
    example_mode, see_also_mode = False, False
    for l in doc.split('\n'):
        if see_also_mode:
            if l.strip():
                new_doc += '[#%s %s]\n' % (l.strip(), l.strip())  
                continue
            else:
                new_doc += '\n'
                see_also_mode = False
        if example_mode:
            new_doc += l.replace(' ', '', 4) + '\n'
            continue 
        l = l.lstrip()
        if l == 'Arguments:':
            new_doc += '=====Arguments=====\n\n'
        elif l == 'Keyword Arguments:':
            new_doc += '=====Keyword Arguments=====\n\n'
        elif l.strip() == 'Example:':
            new_doc += '=====Example=====\n\n'
            new_doc += '<code language = "python">\n'
            example_mode = True
        elif l.strip() == 'See Also:':
            new_doc += '=====See Also=====\n\n'
            see_also_mode = True
        elif l.strip() == 'Examples:':
            new_doc += '=====Examples=====\n\n'
            new_doc += '<code language = "python">\n'
            example_mode = True        
        elif l.find('--') != -1:
            p = l.find('--')
            arg = l[: p].strip()
            argdef = l[p + 2:].strip()
            new_doc += '\n`%s` - %s\n' % (arg, argdef)
        else:
            new_doc += l + '\n'
    if example_mode:
        new_doc += '</code>'
        print(new_doc)
    return new_doc


_name_docs = {}
for wh in dagpype.__all__:
    doc = _grab_doc(wh)
    _name_docs[wh] = doc
_np_name_docs = {}
for wh in dagpype.np.__all__:
    try:
        doc = _grab_doc('np.%s' % wh)
        _np_name_docs[wh] = doc
    except AttributeError:
        pass
_plot_name_docs = {}
for wh in dagpype.plot.__all__:
    try:
        doc = _grab_doc('plot.%s' % wh)
        _plot_name_docs[wh] = doc
    except AttributeError:
        pass


_line_sep = '\n----\n'


def _write_dict_links(f, name, d):
    names = sorted(list(d.keys()), key = str.lower)
    f.write(' * [#%s %s]\n' % (name, name))
    for name in names:
        lnk_name = name[ : -1] if name[-1] == '_' else name
        f.write('  * [#%s %s]\n' % (lnk_name, lnk_name))


def _write_dict(f, name, d):
    names = sorted(list(d.keys()), key = str.lower)
    for name in names:
        lnk_name = name[ : -1] if name[-1] == '_' else name
        f.write('===%s===\n\n' % lnk_name)
        f.write('%s\n\n\n' % d[name])
        f.write(_line_sep)


with open('../docs/Ref.wiki', 'w') as f:
    f.write('=Reference=\n\n')    
    _write_dict_links(f, 'dagpype', _name_docs)
    _write_dict_links(f, 'dagpype.np', _np_name_docs)
    _write_dict_links(f, 'dagpype.plot', _plot_name_docs)
    f.write(_line_sep)
    _write_dict(f, 'dagpype', _name_docs)
    _write_dict(f, 'dagpype.plot', _plot_name_docs)

