from matplotlib.pyplot import *

import _no_chunk_csv
import _chunk_file
import _chunk_csv


class _Plotter(object):
    def __init__(self, xlabel_, ylabel_):
        clf()
        xlabel(xlabel_)
        ylabel(ylabel_)
        self._x_vals = []
        self._results = dict([])

    def add_results(self, x_val, res):
        print(res)
        self._x_vals.append(x_val)
        for n in list(res.keys()):
            if n not in self._results:
                self._results[n] = []
            self._results[n].append(res[n])

    def to_file(self, f_name):
        for n in list(self._results.keys()):
            hold(True)
            plot(self._x_vals, self._results[n], label = n)
        legend(list(self._results.keys()))
        savefig(f_name)
        hold(False)


if __name__ == '__main__':
    num_cols = 10
    num_its = 10

    base = 10000

    p = _Plotter('# Elements', 'time (sec)')
    for num_rows in (base * i for i in range(1, 20)):
        print('running', num_rows)
        p.add_results(num_rows, _chunk_csv.run_tests(num_rows, num_cols, num_its))
    p.to_file('ChunksCSV.png')

    p = _Plotter('# Elements', 'time (sec)')
    for num_rows in (base * i for i in range(1, 10)):
        print('running', num_rows)
        p.add_results(num_rows, _no_chunk_csv.run_tests(num_rows, num_cols, num_its))
    p.to_file('NoChunksPerf.png')

    p = _Plotter('# Elements', 'time (sec)')
    for num_elems in (10 * base * i for i in range(1, 30)):
        print('running', num_elems)
        p.add_results(num_elems, _chunk_file.run_tests(num_elems, num_its))
    p.to_file('ChunksPerf.png')

    p = _Plotter('# Elements', 'time (sec)')
    for num_elems in (10 * base * i for i in range(1, 30)):
        print('running', num_elems)
        p.add_results(num_elems, _chunk_file.run_tests_prune(num_elems, num_its))
    p.to_file('ChunksPerfPrune.png')

    p = _Plotter('# Elements', 'time (sec)')
    for num_elems in (10 * base * i for i in range(1, 30)):
        print('running', num_elems)
        p.add_results(num_elems, _chunk_file.run_tests_trunc(num_elems, num_its))
    p.to_file('ChunksPerfTrunc.png')


