import os
import sys
import math
import numpy
import time
import random

import c_corr
sys.path.extend(['..', '../..'])
from dagpype import *


_f_name = 'perf.csv'


def _make_file(num_rows, num_cols):
    if os.path.exists(_f_name):
        os.remove(_f_name)
    with open(_f_name, 'wb') as f:
        f.write(','.join([str(i) for i in range(num_cols)]) + '\n')
        for i in range(num_rows):
            f.write(','.join([str(random.random()) for i in range(num_cols)]) + '\n')


def _pipe_corr():
    c = np.chunk_stream_vals(_f_name, '0') | np.mean()


def _numpy_corr():
    x = numpy.genfromtxt(_f_name, usecols = (0), delimiter = ',')
    a = numpy.mean(x)


def _run_test(fn_name, num_rows, num_cols, num_its):
    _make_file(num_rows, num_cols)
    start = time.time()
    for i in range(num_its):
        eval('%s()' % fn_name)
    end = time.time()
    diff = (end - start) / num_its
    os.remove(_f_name)
    return diff


def run_tests(num_rows, num_cols, num_its):
    t = dict([])
    for name, desc in [
            ('_numpy_corr', 'numpy.genfromtxt'), 
            ('_pipe_corr', 'dagpype')]:
        t[desc] = _run_test(name, num_rows, num_cols, num_its)
    return t

