import os
import sys
import math
import numpy
import time

import c_corr
sys.path.extend(['..', '../..'])
from dagpype import *


_f_name = 'perf.dat'


def _make_file(num_elems):
    with open(_f_name, 'wb') as writer:
        writer.write(numpy.random.rand(num_elems).tostring())


def _pipe_corr():
    c = np.chunk_stream_bytes(_f_name, num_cols = 2) | np.corr()


def _pipe_corr_prune():
    c = np.chunk_stream_bytes(_f_name, num_cols = 2) | \
        filt(lambda a : a[numpy.logical_and(a[:, 0] < 0.25, a[:, 1] < 0.25), :]) | \
        np.corr()


def _pipe_corr_trunc():
    c = np.chunk_stream_bytes(_f_name, num_cols = 2) | \
        filt(lambda a : numpy.where(a < 0.25, a, 0.25)) | \
        np.corr()


def _c_corr():
    c_corr.c_corr(_f_name)


def _c_corr_trunc():
    c_corr.c_corr_trunc(_f_name)


def _c_corr_prune():
    c_corr.c_corr_prune(_f_name)


def _numpy_corr():
    s = open(_f_name, 'rb').read()
    a = numpy.fromstring(s)
    xy = a.reshape(a.shape[0] / 2, 2)    

    s = numpy.sum(xy, axis = 0)
    sx = s[0]
    sy = s[1]

    c = numpy.dot(xy.T, xy)

    sxx = c[0, 0]
    sxy = c[0, 1]
    syy = c[1, 1]

    n = xy.shape[0]
    # print 'numpy core', n, 'values'
    res = (n * sxy - sx * sy) / math.sqrt(n * sxx - sx * sx) / math.sqrt(n * syy - sy * sy)


def _numpy_corr_prune():
    s = open(_f_name, 'rb').read()
    a = numpy.fromstring(s)
    xy = a.reshape(a.shape[0] / 2, 2)    
    xy = xy[numpy.logical_and(xy[:, 0] < 0.25, xy[:, 1] < 0.25), :]

    s = numpy.sum(xy, axis = 0)
    sx = s[0]
    sy = s[1]

    c = numpy.dot(xy.T, xy)

    sxx = c[0, 0]
    sxy = c[0, 1]
    syy = c[1, 1]

    n = xy.shape[0]
    # print 'numpy core', n, 'values'
    res = (n * sxy - sx * sy) / math.sqrt(n * sxx - sx * sx) / math.sqrt(n * syy - sy * sy)


def _numpy_corr_trunc():
    s = open(_f_name, 'rb').read()
    a = numpy.fromstring(s)
    xy = a.reshape(a.shape[0] / 2, 2)    
    xy = numpy.where(xy < 0.25, xy, 0.25)

    s = numpy.sum(xy, axis = 0)
    sx = s[0]
    sy = s[1]

    c = numpy.dot(xy.T, xy)

    sxx = c[0, 0]
    sxy = c[0, 1]
    syy = c[1, 1]

    n = xy.shape[0]
    # print 'numpy core', n, 'values'
    res = (n * sxy - sx * sy) / math.sqrt(n * sxx - sx * sx) / math.sqrt(n * syy - sy * sy)


def _run_test(fn_name, num_elems, num_its):
    _make_file(2 * num_elems)
    start = time.time()
    for i in range(num_its):
        eval('%s()' % fn_name)
    end = time.time()
    diff = (end - start) / num_its
    os.remove(_f_name)
    return diff


def run_tests(num_elems, num_its):
    t = dict([])
    for name, desc in [
            ('_numpy_corr', 'numpy single'), 
            ('_pipe_corr', 'dagpype'), 
            ('_c_corr', 'C')]:
        t[desc] = _run_test(name, num_elems, num_its)
    return t


def run_tests_prune(num_elems, num_its):
    t = dict([])
    for name, desc in [
            ('_numpy_corr_prune', 'numpy single'), 
            ('_pipe_corr_prune', 'dagpype'), 
            ('_c_corr_prune', 'C')]:
        t[desc] = _run_test(name, num_elems, num_its)
    return t

def run_tests_trunc(num_elems, num_its):
    t = dict([])
    for name, desc in [
            ('_numpy_corr_trunc', 'numpy single'), 
            ('_pipe_corr_trunc', 'dagpype'), 
            ('_c_corr_trunc', 'C')]:
        t[desc] = _run_test(name, num_elems, num_its)
    return t

