import os
import sys
import math
import csv
import random
import time

sys.path.extend(['..', '../..'])
from dagpype import *


_f_name = 'perf.csv'


def _make_file(num_rows, num_cols):
    if os.path.exists(_f_name):
        os.remove(_f_name)
    with open(_f_name, 'wb') as f:
        f.write(','.join([str(i) for i in range(num_cols)]) + '\n')
        for i in range(num_rows):
            f.write(','.join([str(random.random()) for i in range(num_cols)]) + '\n')


def _csv_corr():
    r = csv.reader(open(_f_name, 'rb'))

    fields = next(r)
    ind0, ind1 = fields.index('0'), fields.index('1')

    sx, sxx, sy, syy, sxy, n = 0, 0, 0, 0, 0, 0
    try:        
        while True:
            row = next(r)
            x, y = float(row[ind0]), float(row[ind1])
            if x < 0.5 and y < 0.5:
                sx += x
                sxx += x * x
                sy += y
                sxy += x * y
                syy += y * y
                n += 1
    except StopIteration:
        c = (n * sxy - sx * sy) / math.sqrt(n * sxx - sx * sx) / math.sqrt(n * syy - sy * sy)


def _dict_corr():
    r = csv.DictReader(open(_f_name, 'rb'), ('0', '1'))

    sx, sxx, sy, syy, sxy, n = 0, 0, 0, 0, 0, 0
    for row in r:
        x, y = float(row['0']), float(row['1'])
        if x < 0.5 and y < 0.5:
            sx += x
            sxx += x * x
            sy += y
            sxy += x * y
            syy += y * y
            n += 1
    c = (n * sxy - sx * sy) / math.sqrt(n * sxx - sx * sx) / math.sqrt(n * syy - sy * sy)


def _csv_pipes_corr():
    c = stream_vals(open(_f_name, 'rb'), ('0', '1')) | \
        filt(pre = lambda x_y : x_y[0] < 0.5 and x_y[1] < 0.5) | \
        corr()


def _run_test(fn_name, num_rows, num_cols, num_its):
    _make_file(num_rows, num_cols)
    start = time.time()
    for i in range(num_its):
        eval('%s()' % fn_name)
    end = time.time()
    diff = (end - start) / num_its
    os.remove(_f_name)
    return diff


def run_tests(num_rows, num_cols, num_its):
    t = dict([])
    for name, desc in [
            ('_csv_corr', 'csv.reader'), 
            ('_csv_pipes_corr', 'dagpype'), 
            ('_dict_corr', 'csv.DictReader')]:
        t[desc] = _run_test(name, num_rows, num_cols, num_its)
    return t

