from distutils.core import setup, Extension
import numpy.distutils.misc_util
import os
import os.path


dagpype_c = Extension('dagpype_c',
    include_dirs = ['/usr/local/include'] + 
        numpy.distutils.misc_util.get_numpy_include_dirs(),
    language = 'c++',
    extra_compile_args = [],
    library_dirs = ['/usr/local/lib'],    
    depends = [
        'dagpype/dbg.hpp',
        'dagpype/col_reader.hpp', 
        'dagpype/array_col_reader.hpp', 
        'dagpype/_line_to_array.hpp', 
        'dagpype/defs.hpp',
        'dagpype/parser_defs.hpp',
        'dagpype/line_to_tuple.hpp',
        'dagpype/exp_averager.hpp'],
    sources = [
        'dagpype/col_reader.cpp', 
        'dagpype/array_col_reader.cpp', 
        'dagpype/_line_to_array.cpp', 
        'dagpype/module.cpp', 
        'dagpype/defs.cpp',
        'dagpype/parser_defs.cpp',
        'dagpype/line_to_tuple.cpp',
        'dagpype/exp_averager.cpp'])


setup(
    name = 'DAGPype',
    version = '0.1.3.4',
    author = 'Ami Tavory',
    author_email = 'atavory at gmail.com',
    packages = ['dagpype', 'dagpype.np', 'dagpype.plot'],
    url = 'http://code.google.com/p/dagpype/',
    license = 'LICENSE.txt',
    description = 'Low-footprint flexible DAG data-processing and data-preparation pipelines.',
    long_description = open('README.txt').read(),
    requires = ['numpy'],
    ext_modules = [dagpype_c],
    classifiers = [
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'Intended Audience :: Science/Research',
        'License :: OSI Approved :: BSD License',
        'Programming Language :: Python',
        'Operating System :: OS Independent',   
        'Topic :: Scientific/Engineering',
        'Topic :: Software Development :: Libraries :: Python Modules'])




