#include <iostream>

#include <Python.h>
#include <structmember.h>
#include <numpy/arrayobject.h>

#include "defs.hpp"
#include "enumerator.hpp"

using namespace std;

struct Enumerator
{
    PyObject_HEAD
    
    long count;
};

extern PyTypeObject EnumeratorType;

extern "C" int
enumerator_traverse(Enumerator * self, visitproc visit, void *arg)
{
    return 0;
}

extern "C" void
enumerator_dealloc(Enumerator * self)
{
    PyObject_GC_UnTrack(self);

    PyObject_GC_Del(self);
}

extern "C" PyObject *
enumerator(PyObject *module, PyObject *args, PyObject *keyword_args)
{
    Enumerator * const self = PyObject_GC_New(Enumerator, &EnumeratorType);
    if (self == NULL) {
        PyErr_NoMemory();
        return NULL;
    }

    if (!PyArg_ParseTuple(
            args, 
            "l",
            &self->count)) {
        PyErr_SetString(PyExc_TypeError, "Failed to parse stuff");
        return NULL;
    }

    PyObject_GC_Track(self);
    return (PyObject *)self;
}

extern "C" int
enumerator_clear(Enumerator * self)
{
    self->count = 0;

    return 0;
}

extern "C" PyObject *
enumerator_next(PyObject *module, PyObject *args, PyObject *keyword_args)
{
    Enumerator * self;
    PyObject * o;
    if (!PyArg_ParseTuple(
            args, 
            "OO",
            reinterpret_cast<PyObject **>(&self), 
            &o) || self == NULL || o == NULL) {
        PyErr_SetString(PyExc_TypeError, "Failed to parse stuff");
        return NULL;
    }
    
    Py_INCREF(o);
    
    PyObject * const fields = PyTuple_New(2);
    if (fields == NULL) {
        PyErr_NoMemory();
        Py_XDECREF(o);
        return NULL;
    }
        
    PyObject * const n = PyInt_FromLong(self->count++);
    if (n == NULL) {
        PyErr_NoMemory();
        Py_XDECREF(fields);
        Py_XDECREF(o);
        return NULL;
    }    
        
    PyTuple_SET_ITEM(fields, 0, n);        
    PyTuple_SET_ITEM(fields, 1, o);   
    
    return fields;     
}

static PyMethodDef enumerator_methods[] = {
    { NULL}
};

static PyMemberDef enumerator_memberlist[] = {
    { NULL }
};

PyDoc_STRVAR(EnumeratorType_doc, "");

PyTypeObject EnumeratorType = {
    PyVarObject_HEAD_INIT(NULL, 0)
    "dagpype_c.enumerator",               /*tp_name*/
    sizeof(Enumerator),                   /*tp_basicsize*/
    0,                                      /*tp_itemsize*/
    /* methods */
    (destructor)enumerator_dealloc,          /*tp_dealloc*/
    (printfunc)0,                           /*tp_print*/
    (getattrfunc)0,                         /*tp_getattr*/
    (setattrfunc)0,                         /*tp_setattr*/
    (cmpfunc)0,                             /*tp_compare*/
    (reprfunc)0,                            /*tp_repr*/
    0,                                      /*tp_as_number*/
    0,                                      /*tp_as_sequence*/
    0,                                      /*tp_as_mapping*/
    (hashfunc)0,                            /*tp_hash*/
    (ternaryfunc)0,                         /*tp_call*/
    (reprfunc)0,                            /*tp_str*/
    0,                                      /*tp_getattro*/
    0,                                      /*tp_setattro*/
    0,                                      /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | 
    Py_TPFLAGS_HAVE_GC,                     /*tp_flags*/
    EnumeratorType_doc,                     /*tp_doc*/
    (traverseproc)enumerator_traverse,       /*tp_traverse*/
    (inquiry)enumerator_clear,               /*tp_clear*/
    0,                                      /*tp_richcompare*/
    0,                                      /*tp_weaklistoffset*/
    0,                      /*tp_iter*/
    0,                              /*tp_iternext*/
    enumerator_methods,                      /*tp_methods*/
    enumerator_memberlist,                   /*tp_members*/
    0,                                      /*tp_getset*/
};

