#define MODULE_VERSION "1.0"

#include "Python.h"
#include "structmember.h"
#define PY_ARRAY_UNIQUE_SYMBOL dagpype_c
#include <numpy/arrayobject.h>

#include <cstdio>
#include <cstdlib>

#include "defs.hpp"
#include "col_reader.hpp"
#include "line_writer.hpp"
#include "array_col_reader.hpp"
#include "_line_to_array.hpp"
#include "line_to_tuple.hpp"
#include "exp_averager.hpp"
#include "enumerator.hpp"
#include "correlator.hpp"

using namespace std;

struct module_state
{
    PyObject *error;
};

static module_state _state;

static PyMethodDef dagpype_c_methods[] =
{
    { "line_to_tuple", (PyCFunction)line_to_tuple, METH_VARARGS, NULL},
    { "parser_max_field_len", (PyCFunction)parser_max_field_len, METH_VARARGS, NULL},
    { "col_reader", (PyCFunction)col_reader, METH_VARARGS, NULL},
    { "col_reader_parse_string", (PyCFunction)col_reader_parse_string, METH_VARARGS, NULL},
    { "line_writer", (PyCFunction)line_writer, METH_VARARGS, NULL},
    { "line_writer_write", (PyCFunction)line_writer_write, METH_VARARGS, NULL},
    { "line_writer_close", (PyCFunction)line_writer_close, METH_VARARGS, NULL},
    { "array_col_reader", (PyCFunction)array_col_reader, METH_VARARGS, NULL},
    { "exp_averager", (PyCFunction)exp_averager, METH_VARARGS, NULL},
    { "exp_averager_ave", (PyCFunction)exp_averager_ave, METH_VARARGS, NULL},
    { "enumerator", (PyCFunction)enumerator, METH_VARARGS, NULL},
    { "enumerator_next", (PyCFunction)enumerator_next, METH_VARARGS, NULL},
    { "correlator", (PyCFunction)correlator, METH_VARARGS, NULL},
    { "correlator_push", (PyCFunction)correlator_push, METH_VARARGS, NULL},
    { "correlator_corr", (PyCFunction)correlator_corr, METH_VARARGS, NULL},
    { NULL, NULL }
};

#define INITERROR return

extern "C" void
initdagpype_c()
{
    PyObject *module = Py_InitModule("dagpype_c", dagpype_c_methods);
    if (module == NULL)
        INITERROR;

    _state.error = PyErr_NewException("dagpype_c.Error", NULL, NULL);
    if (_state.error == NULL)
    {
        Py_DECREF(module);
        INITERROR;
    }

    import_array();
}
