#define MODULE_VERSION "1.0"

#include "Python.h"
#include "structmember.h"
#define PY_ARRAY_UNIQUE_SYMBOL dagpype_c
#include <numpy/arrayobject.h>

#include <cstdio>
#include <cstdlib>

#include "defs.hpp"
#include "col_reader.hpp"
#include "line_writer.hpp"
#include "array_col_reader.hpp"
#include "_line_to_array.hpp"
#include "line_to_tuple.hpp"
#include "exp_averager.hpp"
#include "enumerator.hpp"
#include "correlator.hpp"

using namespace std;

struct module_state 
{
    PyObject *error;
};

#if PY_MAJOR_VERSION >= 3
#define GETSTATE(m) ((struct module_state*)PyModule_GetState(m))
#else
#define GETSTATE(m) (&_state)
static struct module_state _state;
#endif

static PyObject *
error_out(PyObject *m) {
    struct module_state *st = GETSTATE(m);
    PyErr_SetString(st->error, "something bad happened");
    return NULL;
}

static PyMethodDef dagpype_c_methods[] =
{
    { "line_to_tuple", (PyCFunction)line_to_tuple, METH_VARARGS, NULL},
    { "parser_max_field_len", (PyCFunction)parser_max_field_len, METH_VARARGS, NULL},
    { "col_reader", (PyCFunction)col_reader, METH_VARARGS, NULL},
    { "col_reader_parse_string", (PyCFunction)col_reader_parse_string, METH_VARARGS, NULL},
    { "line_writer", (PyCFunction)line_writer, METH_VARARGS, NULL},
    { "line_writer_write", (PyCFunction)line_writer_write, METH_VARARGS, NULL},
    { "line_writer_close", (PyCFunction)line_writer_close, METH_VARARGS, NULL},
    { "array_col_reader", (PyCFunction)array_col_reader, METH_VARARGS, NULL},
    { "exp_averager", (PyCFunction)exp_averager, METH_VARARGS, NULL},
    { "exp_averager_ave", (PyCFunction)exp_averager_ave, METH_VARARGS, NULL},
    { "enumerator", (PyCFunction)enumerator, METH_VARARGS, NULL},
    { "enumerator_next", (PyCFunction)enumerator_next, METH_VARARGS, NULL},
    { "correlator", (PyCFunction)correlator, METH_VARARGS, NULL},
    { "correlator_push", (PyCFunction)correlator_push, METH_VARARGS, NULL},
    { "correlator_corr", (PyCFunction)correlator_corr, METH_VARARGS, NULL},
    { NULL, NULL }
};

#if PY_MAJOR_VERSION >= 3

static int dagpype_c_traverse(PyObject *m, visitproc visit, void *arg) {
    Py_VISIT(GETSTATE(m)->error);
    return 0;
}

static int dagpype_c_clear(PyObject *m) {
    Py_CLEAR(GETSTATE(m)->error);
    return 0;
}

static struct PyModuleDef moduledef = {
    PyModuleDef_HEAD_INIT,
    "dagpype_c",
    NULL,
    sizeof(struct module_state),
    dagpype_c_methods,
    NULL,
    dagpype_c_traverse,
    dagpype_c_clear,
    NULL
};

#define INITERROR return NULL

extern "C" PyObject *
PyInit_dagpype_c(void)

#else
#define INITERROR return

extern "C" void
initdagpype_c(void)
#endif
{
#if PY_MAJOR_VERSION >= 3
    PyObject *module = PyModule_Create(&moduledef);
#else
    PyObject *module = Py_InitModule("dagpype_c", dagpype_c_methods);
#endif

    if (module == NULL)
        INITERROR;
    struct module_state *st = GETSTATE(module);

    st->error = PyErr_NewException("dagpype_c.Error", NULL, NULL);
    if (st->error == NULL) {
        Py_DECREF(module);
        INITERROR;
    }
    
    import_array();
    
#if PY_MAJOR_VERSION >= 3
    return module;
#endif
}
