#ifndef PARSER_DEFS_HPP
#define PARSER_DEFS_HPP

#include <utility>
#include <vector>

#include "defs.hpp"

#if defined(__GNUC__) && !defined(DAGPYPE_NO_USE_AIO)
#define DAGPYPE_USE_AIO
#endif // #if defined(__GNUC__) && !defined(DAGPYPE_NO_USE_AIO)

typedef std::vector<char> buf_t;

enum{_int = 0, _float = 1, _str = 2};
enum{_inds_cols = 0, _names_cols = 1, _all_cols = 2};
enum{max_num_cols = 1000, max_field_len = 128};

typedef std::pair<const char *, const char *> parsed_t;

PyObject * 
parsed_to_string(const parsed_t & t);

long
parsed_to_long(const parsed_t & t, bool & err);
PyObject * 
parsed_to_int(const parsed_t & t);

double
parsed_to_double(const parsed_t & t, bool & err);
PyObject * 
parsed_to_float(const parsed_t & t);

char * 
pystring_as_string(PyObject * o, long & len);

long *
parse_longs(PyObject * iterator, long & num, bool & err);
char * *
parse_strings(PyObject * iterator, long & num, bool & err);

extern "C" PyObject *
parser_max_field_len(PyObject *module, PyObject *args, PyObject *keyword_args);

#endif // #ifndef PARSER_DEFS_HPP
