/* File: directmodule.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * See http://cens.ioc.ee/projects/f2py2e/
 * Generation date: Fri Nov 09 08:07:36 2012
 * $Revision:$
 * $Date:$
 * Do not edit this file directly unless you know what you are doing!!!
 */
#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include "Python.h"
#include <stdarg.h>
#include "fortranobject.h"
#include <string.h>
#include <setjmp.h>
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *direct_error;
static PyObject *direct_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef signed char signed_char;
typedef char * string;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
typedef void(*cb_fcn_in_direct__user__routines_typedef)(int *,double *,double *,int *,int *,int *,double *,int *,string *,int *);

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#define PRINTPYOBJERR(obj)\
  fprintf(stderr,"direct.error is related to ");\
  PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
  fprintf(stderr,"\n");

\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
  if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
    PyErr_SetString(PyExc_MemoryError, "out of memory");\
    goto capi_fail;\
  } else {\
    (str)[len] = '\0';\
  }

#define GETSCALARFROMPYTUPLE(tuple,index,var,ctype,mess) {\
    if ((capi_tmp = PyTuple_GetItem((tuple),(index)))==NULL) goto capi_fail;\
    if (!(ctype ## _from_pyobj((var),capi_tmp,mess)))\
      goto capi_fail;\
  }

#define pyobj_from_int1(v) (PyInt_FromLong(v))
#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
  PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
  fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (((PyArrayObject *)(capi_ ## var ## _tmp))->nd)
#define old_shape(var,dim) (((PyArrayObject *)(capi_ ## var ## _tmp))->dimensions[dim])
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#define SWAP(a,b,t) {\
  t *c;\
  c = a;\
  a = b;\
  b = c;}

#define CHECKSCALAR(check,tcheck,name,show,var)\
  if (!(check)) {\
    char errstring[256];\
    sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
    PyErr_SetString(direct_error,errstring);\
    /*goto capi_fail;*/\
  } else 
#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int double_from_pyobj(double* v,PyObject *obj,const char *errmess) {
  PyObject* tmp = NULL;
  if (PyFloat_Check(obj)) {
#ifdef __sgi
    *v = PyFloat_AsDouble(obj);
#else
    *v = PyFloat_AS_DOUBLE(obj);
#endif
    return 1;
  }
  tmp = PyNumber_Float(obj);
  if (tmp) {
#ifdef __sgi
    *v = PyFloat_AsDouble(tmp);
#else
    *v = PyFloat_AS_DOUBLE(tmp);
#endif
    Py_DECREF(tmp);
    return 1;
  }
  if (PyComplex_Check(obj))
    tmp = PyObject_GetAttrString(obj,"real");
  else if (PyString_Check(obj) || PyUnicode_Check(obj))
    /*pass*/;
  else if (PySequence_Check(obj))
    tmp = PySequence_GetItem(obj,0);
  if (tmp) {
    PyErr_Clear();
    if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
    Py_DECREF(tmp);
  }
  {
    PyObject* err = PyErr_Occurred();
    if (err==NULL) err = direct_error;
    PyErr_SetString(err,errmess);
  }
  return 0;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
  PyObject* tmp = NULL;
  if (PyInt_Check(obj)) {
    *v = (int)PyInt_AS_LONG(obj);
    return 1;
  }
  tmp = PyNumber_Int(obj);
  if (tmp) {
    *v = PyInt_AS_LONG(tmp);
    Py_DECREF(tmp);
    return 1;
  }
  if (PyComplex_Check(obj))
    tmp = PyObject_GetAttrString(obj,"real");
  else if (PyString_Check(obj) || PyUnicode_Check(obj))
    /*pass*/;
  else if (PySequence_Check(obj))
    tmp = PySequence_GetItem(obj,0);
  if (tmp) {
    PyErr_Clear();
    if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
    Py_DECREF(tmp);
  }
  {
    PyObject* err = PyErr_Occurred();
    if (err==NULL) err = direct_error;
    PyErr_SetString(err,errmess);
  }
  return 0;
}

static int string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess) {
  PyArrayObject *arr = NULL;
  PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
  if (obj == Py_None) {
    if (*len == -1)
      *len = strlen(inistr); /* Will this cause problems? */
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,inistr,*len+1);
    return 1;
  }
  if (PyArray_Check(obj)) {
    if ((arr = (PyArrayObject *)obj) == NULL)
      goto capi_fail;
    if (!ISCONTIGUOUS(arr)) {
      PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
      goto capi_fail;
    }
    if (*len == -1)
      *len = (arr->descr->elsize)*PyArray_SIZE(arr);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,arr->data,*len+1);
    return 1;
  }
  if (PyString_Check(obj)) {
    tmp = obj;
    Py_INCREF(tmp);
  }
#if PY_VERSION_HEX >= 0x03000000
  else if (PyUnicode_Check(obj)) {
    tmp = PyUnicode_AsASCIIString(obj);
  }
  else {
    PyObject *tmp2;
    tmp2 = PyObject_Str(obj);
    if (tmp2) {
      tmp = PyUnicode_AsASCIIString(tmp2);
      Py_DECREF(tmp2);
    }
    else {
      tmp = NULL;
    }
  }
#else
  else {
    tmp = PyObject_Str(obj);
  }
#endif
  if (tmp == NULL) goto capi_fail;
  if (*len == -1)
    *len = PyString_GET_SIZE(tmp);
  STRINGMALLOC(*str,*len);
  STRINGCOPYN(*str,PyString_AS_STRING(tmp),*len+1);
  Py_DECREF(tmp);
  return 1;
capi_fail:
  Py_XDECREF(tmp);
  {
    PyObject* err = PyErr_Occurred();
    if (err==NULL) err = direct_error;
    PyErr_SetString(err,errmess);
  }
  return 0;
}

static int create_cb_arglist(PyObject* fun,PyTupleObject* xa,const int maxnofargs,const int nofoptargs,int *nofargs,PyTupleObject **args,const char *errmess) {
  PyObject *tmp = NULL;
  PyObject *tmp_fun = NULL;
  int tot,opt,ext,siz,i,di=0;
  CFUNCSMESS("create_cb_arglist\n");
  tot=opt=ext=siz=0;
  /* Get the total number of arguments */
  if (PyFunction_Check(fun))
    tmp_fun = fun;
  else {
    di = 1;
    if (PyObject_HasAttrString(fun,"im_func")) {
      tmp_fun = PyObject_GetAttrString(fun,"im_func");
    }
    else if (PyObject_HasAttrString(fun,"__call__")) {
      tmp = PyObject_GetAttrString(fun,"__call__");
      if (PyObject_HasAttrString(tmp,"im_func"))
        tmp_fun = PyObject_GetAttrString(tmp,"im_func");
      else {
        tmp_fun = fun; /* built-in function */
        tot = maxnofargs;
        if (xa != NULL)
          tot += PyTuple_Size((PyObject *)xa);
      }
      Py_XDECREF(tmp);
    }
    else if (PyFortran_Check(fun) || PyFortran_Check1(fun)) {
      tot = maxnofargs;
      if (xa != NULL)
        tot += PyTuple_Size((PyObject *)xa);
      tmp_fun = fun;
    }
    else if (F2PyCapsule_Check(fun)) {
      tot = maxnofargs;
      if (xa != NULL)
        ext = PyTuple_Size((PyObject *)xa);
      if(ext>0) {
        fprintf(stderr,"extra arguments tuple cannot be used with CObject call-back\n");
        goto capi_fail;
      }
      tmp_fun = fun;
    }
  }
if (tmp_fun==NULL) {
fprintf(stderr,"Call-back argument must be function|instance|instance.__call__|f2py-function but got %s.\n",(fun==NULL?"NULL":Py_TYPE(fun)->tp_name));
goto capi_fail;
}
#if PY_VERSION_HEX >= 0x03000000
  if (PyObject_HasAttrString(tmp_fun,"__code__")) {
    if (PyObject_HasAttrString(tmp = PyObject_GetAttrString(tmp_fun,"__code__"),"co_argcount"))
#else
  if (PyObject_HasAttrString(tmp_fun,"func_code")) {
    if (PyObject_HasAttrString(tmp = PyObject_GetAttrString(tmp_fun,"func_code"),"co_argcount"))
#endif
      tot = PyInt_AsLong(PyObject_GetAttrString(tmp,"co_argcount")) - di;
    Py_XDECREF(tmp);
  }
  /* Get the number of optional arguments */
#if PY_VERSION_HEX >= 0x03000000
  if (PyObject_HasAttrString(tmp_fun,"__defaults__"))
    if (PyTuple_Check(tmp = PyObject_GetAttrString(tmp_fun,"__defaults__")))
#else
  if (PyObject_HasAttrString(tmp_fun,"func_defaults"))
    if (PyTuple_Check(tmp = PyObject_GetAttrString(tmp_fun,"func_defaults")))
#endif
      opt = PyTuple_Size(tmp);
    Py_XDECREF(tmp);
  /* Get the number of extra arguments */
  if (xa != NULL)
    ext = PyTuple_Size((PyObject *)xa);
  /* Calculate the size of call-backs argument list */
  siz = MIN(maxnofargs+ext,tot);
  *nofargs = MAX(0,siz-ext);
#ifdef DEBUGCFUNCS
  fprintf(stderr,"debug-capi:create_cb_arglist:maxnofargs(-nofoptargs),tot,opt,ext,siz,nofargs=%d(-%d),%d,%d,%d,%d,%d\n",maxnofargs,nofoptargs,tot,opt,ext,siz,*nofargs);
#endif
  if (siz<tot-opt) {
    fprintf(stderr,"create_cb_arglist: Failed to build argument list (siz) with enough arguments (tot-opt) required by user-supplied function (siz,tot,opt=%d,%d,%d).\n",siz,tot,opt);
    goto capi_fail;
  }
  /* Initialize argument list */
  *args = (PyTupleObject *)PyTuple_New(siz);
  for (i=0;i<*nofargs;i++) {
    Py_INCREF(Py_None);
    PyTuple_SET_ITEM((PyObject *)(*args),i,Py_None);
  }
  if (xa != NULL)
    for (i=(*nofargs);i<siz;i++) {
      tmp = PyTuple_GetItem((PyObject *)xa,i-(*nofargs));
      Py_INCREF(tmp);
      PyTuple_SET_ITEM(*args,i,tmp);
    }
  CFUNCSMESS("create_cb_arglist-end\n");
  return 1;
capi_fail:
  if ((PyErr_Occurred())==NULL)
    PyErr_SetString(direct_error,errmess);
  return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC(direct,DIRECT)(cb_fcn_in_direct__user__routines_typedef,double*,int*,double*,int*,int*,double*,double*,double*,int*,int*,string,double*,double*,double*,double*,int*,int*,double*,int*,string*,int*,size_t);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/

/********************** cb_fcn_in_direct__user__routines **********************/
PyObject *cb_fcn_in_direct__user__routines_capi = NULL;/*was Py_None*/
PyTupleObject *cb_fcn_in_direct__user__routines_args_capi = NULL;
int cb_fcn_in_direct__user__routines_nofargs = 0;
jmp_buf cb_fcn_in_direct__user__routines_jmpbuf;
/*typedef void(*cb_fcn_in_direct__user__routines_typedef)(int *,double *,double *,int *,int *,int *,double *,int *,string *,int *);*/
static void cb_fcn_in_direct__user__routines (int *n_cb_capi,double *x,double *f_cb_capi,int *flag_cb_capi,int *iidata,int *iisize_cb_capi,double *ddata,int *idsize_cb_capi,string *cdata,int *icsize_cb_capi) {
  PyTupleObject *capi_arglist = cb_fcn_in_direct__user__routines_args_capi;
  PyObject *capi_return = NULL;
  PyObject *capi_tmp = NULL;
  int capi_j,capi_i = 0;
  int capi_longjmp_ok = 1;
/*decl*/
  int n=(*n_cb_capi);
  double f=(*f_cb_capi);
  int flag=(*flag_cb_capi);
  int iisize=(*iisize_cb_capi);
  int idsize=(*idsize_cb_capi);
  int icsize=(*icsize_cb_capi);
  npy_intp iidata_Dims[1] = {-1};
  npy_intp cdata_Dims[2] = {-1, -1};
  npy_intp x_Dims[1] = {-1};
  npy_intp ddata_Dims[1] = {-1};
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_clock();
#endif
  CFUNCSMESS("cb:Call-back function cb_fcn_in_direct__user__routines (maxnofargs=8(-4))\n");
  CFUNCSMESSPY("cb:cb_fcn_in_direct__user__routines_capi=",cb_fcn_in_direct__user__routines_capi);
  if (cb_fcn_in_direct__user__routines_capi==NULL) {
    capi_longjmp_ok = 0;
    cb_fcn_in_direct__user__routines_capi = PyObject_GetAttrString(direct_module,"fcn");
  }
  if (cb_fcn_in_direct__user__routines_capi==NULL) {
    PyErr_SetString(direct_error,"cb: Callback fcn not defined (as an argument or module direct attribute).\n");
    goto capi_fail;
  }
  if (F2PyCapsule_Check(cb_fcn_in_direct__user__routines_capi)) {
  cb_fcn_in_direct__user__routines_typedef cb_fcn_in_direct__user__routines_cptr;
  cb_fcn_in_direct__user__routines_cptr = F2PyCapsule_AsVoidPtr(cb_fcn_in_direct__user__routines_capi);
  (*cb_fcn_in_direct__user__routines_cptr)(n_cb_capi,x,f_cb_capi,flag_cb_capi,iidata,iisize_cb_capi,ddata,idsize_cb_capi,cdata,icsize_cb_capi);
  return;
  }
  if (capi_arglist==NULL) {
    capi_longjmp_ok = 0;
    capi_tmp = PyObject_GetAttrString(direct_module,"fcn_extra_args");
    if (capi_tmp) {
      capi_arglist = (PyTupleObject *)PySequence_Tuple(capi_tmp);
      if (capi_arglist==NULL) {
        PyErr_SetString(direct_error,"Failed to convert direct.fcn_extra_args to tuple.\n");
        goto capi_fail;
      }
    } else {
      PyErr_Clear();
      capi_arglist = (PyTupleObject *)Py_BuildValue("()");
    }
  }
  if (capi_arglist == NULL) {
    PyErr_SetString(direct_error,"Callback fcn argument list is not set.\n");
    goto capi_fail;
  }
/*setdims*/
  iidata_Dims[0]=iisize;
  cdata_Dims[0]=icsize,cdata_Dims[1]=40;
  x_Dims[0]=n;
  ddata_Dims[0]=idsize;
/*pyobjfrom*/
  if (cb_fcn_in_direct__user__routines_nofargs>capi_i) {
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,x_Dims,PyArray_DOUBLE,NULL,(char*)x,0,NPY_FARRAY,NULL); /*XXX: Hmm, what will destroy this array??? */


    if (tmp_arr==NULL)
      goto capi_fail;
    if (PyTuple_SetItem((PyObject *)capi_arglist,capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
  if (cb_fcn_in_direct__user__routines_nofargs>capi_i) {
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,iidata_Dims,PyArray_INT,NULL,(char*)iidata,0,NPY_FARRAY,NULL); /*XXX: Hmm, what will destroy this array??? */


    if (tmp_arr==NULL)
      goto capi_fail;
    if (PyTuple_SetItem((PyObject *)capi_arglist,capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
  if (cb_fcn_in_direct__user__routines_nofargs>capi_i) {
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,ddata_Dims,PyArray_DOUBLE,NULL,(char*)ddata,0,NPY_FARRAY,NULL); /*XXX: Hmm, what will destroy this array??? */


    if (tmp_arr==NULL)
      goto capi_fail;
    if (PyTuple_SetItem((PyObject *)capi_arglist,capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
  if (cb_fcn_in_direct__user__routines_nofargs>capi_i) {
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,2,cdata_Dims,PyArray_CHAR,NULL,(char*)cdata,0,NPY_CARRAY,NULL); /*XXX: Hmm, what will destroy this array??? */


    if (tmp_arr==NULL)
      goto capi_fail;
    if (PyTuple_SetItem((PyObject *)capi_arglist,capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
  if (cb_fcn_in_direct__user__routines_nofargs>capi_i)
    if (PyTuple_SetItem((PyObject *)capi_arglist,capi_i++,pyobj_from_int1(n)))
      goto capi_fail;
  if (cb_fcn_in_direct__user__routines_nofargs>capi_i)
    if (PyTuple_SetItem((PyObject *)capi_arglist,capi_i++,pyobj_from_int1(iisize)))
      goto capi_fail;
  if (cb_fcn_in_direct__user__routines_nofargs>capi_i)
    if (PyTuple_SetItem((PyObject *)capi_arglist,capi_i++,pyobj_from_int1(idsize)))
      goto capi_fail;
  if (cb_fcn_in_direct__user__routines_nofargs>capi_i)
    if (PyTuple_SetItem((PyObject *)capi_arglist,capi_i++,pyobj_from_int1(icsize)))
      goto capi_fail;
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist);
  CFUNCSMESS("cb:Call-back calling Python function fcn.\n");
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_call_clock();
#endif
  capi_return = PyObject_CallObject(cb_fcn_in_direct__user__routines_capi,(PyObject *)capi_arglist);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_call_clock();
#endif
  CFUNCSMESSPY("cb:capi_return=",capi_return);
  if (capi_return == NULL) {
    fprintf(stderr,"capi_return is NULL\n");
    goto capi_fail;
  }
  if (capi_return == Py_None) {
    Py_DECREF(capi_return);
    capi_return = Py_BuildValue("()");
  }
  else if (!PyTuple_Check(capi_return)) {
    capi_return = Py_BuildValue("(N)",capi_return);
  }
  capi_j = PyTuple_Size(capi_return);
  capi_i = 0;
/*frompyobj*/
  if (capi_j>capi_i)
    GETSCALARFROMPYTUPLE(capi_return,capi_i++,f_cb_capi,double,"double_from_pyobj failed in converting argument f of call-back function cb_fcn_in_direct__user__routines to C double\n");
  if (capi_j>capi_i)
    GETSCALARFROMPYTUPLE(capi_return,capi_i++,flag_cb_capi,int,"int_from_pyobj failed in converting argument flag of call-back function cb_fcn_in_direct__user__routines to C int\n");
  CFUNCSMESS("cb:cb_fcn_in_direct__user__routines:successful\n");
  Py_DECREF(capi_return);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_clock();
#endif
  goto capi_return_pt;
capi_fail:
  fprintf(stderr,"Call-back cb_fcn_in_direct__user__routines failed.\n");
  Py_XDECREF(capi_return);
  if (capi_longjmp_ok)
    longjmp(cb_fcn_in_direct__user__routines_jmpbuf,-1);
capi_return_pt:
  ;
return;
}
/****************** end of cb_fcn_in_direct__user__routines ******************/


/*********************** See f2py2e/rules.py: buildapi ***********************/

/*********************************** direct ***********************************/
static char doc_f2py_rout_direct_direct[] = "\
Function signature:\n\
  x,fmin,ierror = direct(fcn,eps,maxf,maxt,l,u,algmethod,logfilename,fglobal,fglper,volper,sigmaper,iidata,ddata,cdata,[n,iisize,idsize,icsize,fcn_extra_args])\n\
Required arguments:\n"
"  fcn : call-back function\n"
"  eps : input float\n"
"  maxf : input int\n"
"  maxt : input int\n"
"  l : input rank-1 array('d') with bounds (n)\n"
"  u : input rank-1 array('d') with bounds (n)\n"
"  algmethod : input int\n"
"  logfilename : input string(len=-1)\n"
"  fglobal : input float\n"
"  fglper : input float\n"
"  volper : input float\n"
"  sigmaper : input float\n"
"  iidata : input rank-1 array('i') with bounds (iisize)\n"
"  ddata : input rank-1 array('d') with bounds (idsize)\n"
"  cdata : input rank-2 array('S') with bounds (icsize,40)\n"
"Optional arguments:\n"
"  fcn_extra_args := () input tuple\n"
"  n := len(l) input int\n"
"  iisize := len(iidata) input int\n"
"  idsize := len(ddata) input int\n"
"  icsize := shape(cdata,0) input int\n"
"Return objects:\n"
"  x : rank-1 array('d') with bounds (n)\n"
"  fmin : float\n"
"  ierror : int\n"
"Call-back functions:\n"
"  def fcn(x,iidata,ddata,cdata,[n,iisize,idsize,icsize]): return f,flag\n\
  Required arguments:\n"
"    x : input rank-1 array('d') with bounds (n)\n"
"    iidata : input rank-1 array('i') with bounds (iisize)\n"
"    ddata : input rank-1 array('d') with bounds (idsize)\n"
"    cdata : input rank-2 array('S') with bounds (icsize,40)\n"
"  Optional arguments:\n"
"    n := len(x) input int\n"
"    iisize := len(iidata) input int\n"
"    idsize := len(ddata) input int\n"
"    icsize := shape(cdata,0) input int\n"
"  Return objects:\n"
"    f : float\n"
"    flag : int";
/* extern void F_FUNC(direct,DIRECT)(cb_fcn_in_direct__user__routines_typedef,double*,int*,double*,int*,int*,double*,double*,double*,int*,int*,string,double*,double*,double*,double*,int*,int*,double*,int*,string*,int*,size_t); */
static PyObject *f2py_rout_direct_direct(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(cb_fcn_in_direct__user__routines_typedef,double*,int*,double*,int*,int*,double*,double*,double*,int*,int*,string,double*,double*,double*,double*,int*,int*,double*,int*,string*,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  PyObject *fcn_capi = Py_None;
  PyTupleObject *fcn_xa_capi = NULL;
  PyTupleObject *fcn_args_capi = NULL;
  int fcn_nofargs_capi = 0;
  cb_fcn_in_direct__user__routines_typedef fcn_cptr;
  double *x = NULL;
  npy_intp x_Dims[1] = {-1};
  const int x_Rank = 1;
  PyArrayObject *capi_x_tmp = NULL;
  int capi_x_intent = 0;
  int n = 0;
  PyObject *n_capi = Py_None;
  double eps = 0;
  PyObject *eps_capi = Py_None;
  int maxf = 0;
  PyObject *maxf_capi = Py_None;
  int maxt = 0;
  PyObject *maxt_capi = Py_None;
  double fmin = 0;
  double *l = NULL;
  npy_intp l_Dims[1] = {-1};
  const int l_Rank = 1;
  PyArrayObject *capi_l_tmp = NULL;
  int capi_l_intent = 0;
  PyObject *l_capi = Py_None;
  double *u = NULL;
  npy_intp u_Dims[1] = {-1};
  const int u_Rank = 1;
  PyArrayObject *capi_u_tmp = NULL;
  int capi_u_intent = 0;
  PyObject *u_capi = Py_None;
  int algmethod = 0;
  PyObject *algmethod_capi = Py_None;
  int ierror = 0;
  string logfilename = NULL;
  int slen(logfilename);
  PyObject *logfilename_capi = Py_None;
  double fglobal = 0;
  PyObject *fglobal_capi = Py_None;
  double fglper = 0;
  PyObject *fglper_capi = Py_None;
  double volper = 0;
  PyObject *volper_capi = Py_None;
  double sigmaper = 0;
  PyObject *sigmaper_capi = Py_None;
  int *iidata = NULL;
  npy_intp iidata_Dims[1] = {-1};
  const int iidata_Rank = 1;
  PyArrayObject *capi_iidata_tmp = NULL;
  int capi_iidata_intent = 0;
  PyObject *iidata_capi = Py_None;
  int iisize = 0;
  PyObject *iisize_capi = Py_None;
  double *ddata = NULL;
  npy_intp ddata_Dims[1] = {-1};
  const int ddata_Rank = 1;
  PyArrayObject *capi_ddata_tmp = NULL;
  int capi_ddata_intent = 0;
  PyObject *ddata_capi = Py_None;
  int idsize = 0;
  PyObject *idsize_capi = Py_None;
  string *cdata = NULL;
  npy_intp cdata_Dims[2] = {-1, -1};
  const int cdata_Rank = 2;
  PyArrayObject *capi_cdata_tmp = NULL;
  int capi_cdata_intent = 0;
  PyObject *cdata_capi = Py_None;
  int icsize = 0;
  PyObject *icsize_capi = Py_None;
  static char *capi_kwlist[] = {"fcn","eps","maxf","maxt","l","u","algmethod","logfilename","fglobal","fglper","volper","sigmaper","iidata","ddata","cdata","n","iisize","idsize","icsize","fcn_extra_args",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOOOOO|OOOOO!:direct.direct",\
    capi_kwlist,&fcn_capi,&eps_capi,&maxf_capi,&maxt_capi,&l_capi,&u_capi,&algmethod_capi,&logfilename_capi,&fglobal_capi,&fglper_capi,&volper_capi,&sigmaper_capi,&iidata_capi,&ddata_capi,&cdata_capi,&n_capi,&iisize_capi,&idsize_capi,&icsize_capi,&PyTuple_Type,&fcn_xa_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable fmin */
  /* Processing variable fglper */
    f2py_success = double_from_pyobj(&fglper,fglper_capi,"direct.direct() 10th argument (fglper) can't be converted to double");
  if (f2py_success) {
  /* Processing variable eps */
    f2py_success = double_from_pyobj(&eps,eps_capi,"direct.direct() 2nd argument (eps) can't be converted to double");
  if (f2py_success) {
  /* Processing variable logfilename */
  slen(logfilename) = -1;
  f2py_success = string_from_pyobj(&logfilename,&slen(logfilename),"",logfilename_capi,"string_from_pyobj failed in converting 8th argument `logfilename' of direct.direct to C string");
  if (f2py_success) {
  /* Processing variable cdata */
  cdata_Dims[1]=40;
  capi_cdata_intent |= F2PY_INTENT_IN|F2PY_INTENT_C;
  capi_cdata_tmp = array_from_pyobj(PyArray_CHAR,cdata_Dims,cdata_Rank,capi_cdata_intent,cdata_capi);
  if (capi_cdata_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(direct_error,"failed in converting 15th argument `cdata' of direct.direct to C/Fortran array" );
  } else {
    cdata = (string *)(capi_cdata_tmp->data);

  /* Processing variable ddata */
  ;
  capi_ddata_intent |= F2PY_INTENT_IN;
  capi_ddata_tmp = array_from_pyobj(PyArray_DOUBLE,ddata_Dims,ddata_Rank,capi_ddata_intent,ddata_capi);
  if (capi_ddata_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(direct_error,"failed in converting 14th argument `ddata' of direct.direct to C/Fortran array" );
  } else {
    ddata = (double *)(capi_ddata_tmp->data);

  /* Processing variable fcn */
if(F2PyCapsule_Check(fcn_capi)) {
  fcn_cptr = F2PyCapsule_AsVoidPtr(fcn_capi);
} else {
  fcn_cptr = cb_fcn_in_direct__user__routines;
}

  fcn_nofargs_capi = cb_fcn_in_direct__user__routines_nofargs;
  if (create_cb_arglist(fcn_capi,fcn_xa_capi,8,4,&cb_fcn_in_direct__user__routines_nofargs,&fcn_args_capi,"failed in processing argument list for call-back fcn.")) {
    jmp_buf fcn_jmpbuf;
    CFUNCSMESS("Saving jmpbuf for `fcn`.\n");
    SWAP(fcn_capi,cb_fcn_in_direct__user__routines_capi,PyObject);
    SWAP(fcn_args_capi,cb_fcn_in_direct__user__routines_args_capi,PyTupleObject);
    memcpy(&fcn_jmpbuf,&cb_fcn_in_direct__user__routines_jmpbuf,sizeof(jmp_buf));
  /* Processing variable sigmaper */
    f2py_success = double_from_pyobj(&sigmaper,sigmaper_capi,"direct.direct() 12nd argument (sigmaper) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ierror */
  /* Processing variable algmethod */
    f2py_success = int_from_pyobj(&algmethod,algmethod_capi,"direct.direct() 7th argument (algmethod) can't be converted to int");
  if (f2py_success) {
  /* Processing variable l */
  ;
  capi_l_intent |= F2PY_INTENT_IN;
  capi_l_tmp = array_from_pyobj(PyArray_DOUBLE,l_Dims,l_Rank,capi_l_intent,l_capi);
  if (capi_l_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(direct_error,"failed in converting 5th argument `l' of direct.direct to C/Fortran array" );
  } else {
    l = (double *)(capi_l_tmp->data);

  /* Processing variable maxt */
    f2py_success = int_from_pyobj(&maxt,maxt_capi,"direct.direct() 4th argument (maxt) can't be converted to int");
  if (f2py_success) {
  /* Processing variable fglobal */
    f2py_success = double_from_pyobj(&fglobal,fglobal_capi,"direct.direct() 9th argument (fglobal) can't be converted to double");
  if (f2py_success) {
  /* Processing variable iidata */
  ;
  capi_iidata_intent |= F2PY_INTENT_IN;
  capi_iidata_tmp = array_from_pyobj(PyArray_INT,iidata_Dims,iidata_Rank,capi_iidata_intent,iidata_capi);
  if (capi_iidata_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(direct_error,"failed in converting 13rd argument `iidata' of direct.direct to C/Fortran array" );
  } else {
    iidata = (int *)(capi_iidata_tmp->data);

  /* Processing variable volper */
    f2py_success = double_from_pyobj(&volper,volper_capi,"direct.direct() 11st argument (volper) can't be converted to double");
  if (f2py_success) {
  /* Processing variable maxf */
    f2py_success = int_from_pyobj(&maxf,maxf_capi,"direct.direct() 3rd argument (maxf) can't be converted to int");
  if (f2py_success) {
  /* Processing variable idsize */
  if (idsize_capi == Py_None) idsize = len(ddata); else
    f2py_success = int_from_pyobj(&idsize,idsize_capi,"direct.direct() 3rd keyword (idsize) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(ddata)>=idsize,"len(ddata)>=idsize","3rd keyword idsize","direct:idsize=%d",idsize) {
  /* Processing variable n */
  if (n_capi == Py_None) n = len(l); else
    f2py_success = int_from_pyobj(&n,n_capi,"direct.direct() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(l)>=n,"len(l)>=n","1st keyword n","direct:n=%d",n) {
  /* Processing variable icsize */
  if (icsize_capi == Py_None) icsize = shape(cdata,0); else
    f2py_success = int_from_pyobj(&icsize,icsize_capi,"direct.direct() 4th keyword (icsize) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(cdata,0)==icsize,"shape(cdata,0)==icsize","4th keyword icsize","direct:icsize=%d",icsize) {
  /* Processing variable x */
  x_Dims[0]=n;
  capi_x_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_x_tmp = array_from_pyobj(PyArray_DOUBLE,x_Dims,x_Rank,capi_x_intent,Py_None);
  if (capi_x_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(direct_error,"failed in converting hidden `x' of direct.direct to C/Fortran array" );
  } else {
    x = (double *)(capi_x_tmp->data);

  /* Processing variable iisize */
  if (iisize_capi == Py_None) iisize = len(iidata); else
    f2py_success = int_from_pyobj(&iisize,iisize_capi,"direct.direct() 2nd keyword (iisize) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(iidata)>=iisize,"len(iidata)>=iisize","2nd keyword iisize","direct:iisize=%d",iisize) {
  /* Processing variable u */
  u_Dims[0]=n;
  capi_u_intent |= F2PY_INTENT_IN;
  capi_u_tmp = array_from_pyobj(PyArray_DOUBLE,u_Dims,u_Rank,capi_u_intent,u_capi);
  if (capi_u_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(direct_error,"failed in converting 6th argument `u' of direct.direct to C/Fortran array" );
  } else {
    u = (double *)(capi_u_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
    if ((setjmp(cb_fcn_in_direct__user__routines_jmpbuf))) {
      f2py_success = 0;
    } else {
        (*f2py_func)(fcn_cptr,x,&n,&eps,&maxf,&maxt,&fmin,l,u,&algmethod,&ierror,logfilename,&fglobal,&fglper,&volper,&sigmaper,iidata,&iisize,ddata,&idsize,cdata,&icsize,slen(logfilename));
    }
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("Ndi",capi_x_tmp,fmin,ierror);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_u_tmp!=u_capi) {
    Py_XDECREF(capi_u_tmp); }
  }  /*if (capi_u_tmp == NULL) ... else of u*/
  /* End of cleaning variable u */
  } /*CHECKSCALAR(len(iidata)>=iisize)*/
  } /*if (f2py_success) of iisize*/
  /* End of cleaning variable iisize */
  }  /*if (capi_x_tmp == NULL) ... else of x*/
  /* End of cleaning variable x */
  } /*CHECKSCALAR(shape(cdata,0)==icsize)*/
  } /*if (f2py_success) of icsize*/
  /* End of cleaning variable icsize */
  } /*CHECKSCALAR(len(l)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*CHECKSCALAR(len(ddata)>=idsize)*/
  } /*if (f2py_success) of idsize*/
  /* End of cleaning variable idsize */
  } /*if (f2py_success) of maxf*/
  /* End of cleaning variable maxf */
  } /*if (f2py_success) of volper*/
  /* End of cleaning variable volper */
  if((PyObject *)capi_iidata_tmp!=iidata_capi) {
    Py_XDECREF(capi_iidata_tmp); }
  }  /*if (capi_iidata_tmp == NULL) ... else of iidata*/
  /* End of cleaning variable iidata */
  } /*if (f2py_success) of fglobal*/
  /* End of cleaning variable fglobal */
  } /*if (f2py_success) of maxt*/
  /* End of cleaning variable maxt */
  if((PyObject *)capi_l_tmp!=l_capi) {
    Py_XDECREF(capi_l_tmp); }
  }  /*if (capi_l_tmp == NULL) ... else of l*/
  /* End of cleaning variable l */
  } /*if (f2py_success) of algmethod*/
  /* End of cleaning variable algmethod */
  /* End of cleaning variable ierror */
  } /*if (f2py_success) of sigmaper*/
  /* End of cleaning variable sigmaper */
    CFUNCSMESS("Restoring jmpbuf for `fcn`.\n");
    cb_fcn_in_direct__user__routines_capi = fcn_capi;
    Py_DECREF(cb_fcn_in_direct__user__routines_args_capi);
    cb_fcn_in_direct__user__routines_args_capi = fcn_args_capi;
    cb_fcn_in_direct__user__routines_nofargs = fcn_nofargs_capi;
    memcpy(&cb_fcn_in_direct__user__routines_jmpbuf,&fcn_jmpbuf,sizeof(jmp_buf));
  }
  /* End of cleaning variable fcn */
  if((PyObject *)capi_ddata_tmp!=ddata_capi) {
    Py_XDECREF(capi_ddata_tmp); }
  }  /*if (capi_ddata_tmp == NULL) ... else of ddata*/
  /* End of cleaning variable ddata */
  if((PyObject *)capi_cdata_tmp!=cdata_capi) {
    Py_XDECREF(capi_cdata_tmp); }
  }  /*if (capi_cdata_tmp == NULL) ... else of cdata*/
  /* End of cleaning variable cdata */
    STRINGFREE(logfilename);
  }  /*if (f2py_success) of logfilename*/
  /* End of cleaning variable logfilename */
  } /*if (f2py_success) of eps*/
  /* End of cleaning variable eps */
  } /*if (f2py_success) of fglper*/
  /* End of cleaning variable fglper */
  /* End of cleaning variable fmin */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of direct *******************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

static FortranDataDef f2py_directcontrol_def[] = {
  {"jones",0,{{-1}},PyArray_INT},
  {NULL}
};
static void f2py_setup_directcontrol(char *jones) {
  int i_f2py=0;
  f2py_directcontrol_def[i_f2py++].data = jones;
}
extern void F_FUNC(f2pyinitdirectcontrol,F2PYINITDIRECTCONTROL)(void(*)(char*));
static void f2py_init_directcontrol(void) {
  F_FUNC(f2pyinitdirectcontrol,F2PYINITDIRECTCONTROL)(f2py_setup_directcontrol);
}

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"direct",-1,{{-1}},0,(char *)F_FUNC(direct,DIRECT),(f2py_init_func)f2py_rout_direct_direct,doc_f2py_rout_direct_direct},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

#if PY_VERSION_HEX >= 0x03000000
static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "direct",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};
#endif

#if PY_VERSION_HEX >= 0x03000000
#define RETVAL m
PyObject *PyInit_direct(void) {
#else
#define RETVAL
PyMODINIT_FUNC initdirect(void) {
#endif
  int i;
  PyObject *m,*d, *s;
#if PY_VERSION_HEX >= 0x03000000
  m = direct_module = PyModule_Create(&moduledef);
#else
  m = direct_module = Py_InitModule("direct", f2py_module_methods);
#endif
  Py_TYPE(&PyFortran_Type) = &PyType_Type;
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module direct (failed to import numpy)"); return RETVAL;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
#if PY_VERSION_HEX >= 0x03000000
  s = PyUnicode_FromString(
#else
  s = PyString_FromString(
#endif
    "This module 'direct' is auto-generated with f2py (version:2).\nFunctions:\n"
"  x,fmin,ierror = direct(fcn,eps,maxf,maxt,l,u,algmethod,logfilename,fglobal,fglper,volper,sigmaper,iidata,ddata,cdata,n=len(l),iisize=len(iidata),idsize=len(ddata),icsize=shape(cdata,0),fcn_extra_args=())\n"
"COMMON blocks:\n""  /directcontrol/ jones\n"".");
  PyDict_SetItemString(d, "__doc__", s);
  direct_error = PyErr_NewException ("direct.error", NULL, NULL);
  Py_DECREF(s);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++)
    PyDict_SetItemString(d, f2py_routine_defs[i].name,PyFortranObject_NewAsAttr(&f2py_routine_defs[i]));

/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

  F2PyDict_SetItemString(d, "directcontrol", PyFortranObject_New(f2py_directcontrol_def,f2py_init_directcontrol));
/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"direct");
#endif

  return RETVAL;
}
#ifdef __cplusplus
}
#endif
