#!/usr/bin/env python

###########################################################################
#   Copyright (C) 2008 by SukkoPera                                       #
#   sukkosoft@sukkology.net                                               #
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
#   This program is distributed in the hope that it will be useful,       #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#   GNU General Public License for more details.                          #
#                                                                         #
#   You should have received a copy of the GNU General Public License     #
#   along with this program; if not, write to the                         #
#   Free Software Foundation, Inc.,                                       #
#   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
###########################################################################

import sys
import urllib
import urllib2
import socket

# TODO Fix all hardcoded addresses.
# API is at https://www.dnsomatic.com/wiki/api
# TODO Base class should be service-independent or DynDNS's (where all others copied from)
class DnsOMatic:
	"""Uses the DNS-o-matic API to update the IP address."""
	_defaultUrl = "https://updates.dnsomatic.com/nic/update?%s";
	_defaultRealm = "DNSOMATIC"
	_getIpUrl = "http://myip.dnsomatic.com"
	_updateAllIPsKludge = "all.dnsomatic.com"

	def __init__ (self, username = None, password = None, baseUrl = _defaultUrl, realm = _defaultRealm):
		self._username = username
		self._password = password
		self._baseUrl = baseUrl
		self._realm = realm
		self._setupHttp ()
		
	def _setupHttp (self):
		"""Sets up all things needed to use Basic HTTP Authentication."""
		if (self._username is not None and self._username != '' and self._password is not None and self._password != ''):
			# Create an OpenerDirector with support for Basic HTTP Authentication
			passwdMan = urllib2.HTTPPasswordMgrWithDefaultRealm ()
			auth_handler = urllib2.HTTPBasicAuthHandler (passwdMan)
			auth_handler.add_password (None, 'https://updates.dnsomatic.com',
				self._username, self._password)
		else:
			# Use the default handler
			auth_handler = None
		self._httpOpener = urllib2.build_opener (auth_handler)

	def getCurrentLocalIP (self):
		"""Retrieve the current local IP through the DNS-O-Matic service."""
		f = self._httpOpener.open (self._getIpUrl)
		ip = "".join (f.readlines ()).strip ()
		return ip
	
	@staticmethod
	def getCurrentRemoteIP (hostname):
		"""Retrieve the IP the hostname we want to update currently points to."""
		try:
			ip = socket.gethostbyname (hostname)
		except socket.gaierror:
			ip = None
		return ip
		
	def update (self, ip = None, hostnames = None):
		"""Executes an update at the remote site."""
		if hostnames is None:
			# Use special value to update ALL addresses:
			hostnames = [self._updateAllIPsKludge]
		ret = []
		for hostname in hostnames:
			desiredIP = self.getCurrentRemoteIP (hostname)
			if desiredIP is not None:
				currentIP = self.getCurrentLocalIP ()
			if desiredIP is None or currentIP != desiredIP:
				params = {"hostname": hostname}
				enc_params = urllib.urlencode (params)
				url = self._baseUrl % (enc_params)
				#print "URL = %s" % url
				try:
					f = self._httpOpener.open (url)
					result = "".join (f.readlines ()).strip ()
					#print result
					if result == "nohost":
						# No such host
						status = result
					else:
						status, ip = result.split ()
				except urllib2.HTTPError:
					status = "badauth"
					ip = None
				res = (status, ip)
			else:
				# Our local IP is the same as the remote one
				res = ("alreadyok", currentIP)
			ret.append (res)				
		return ret


# Experimental, update does not work, dunno why
class OpenDns (DnsOMatic):
	"""Uses the DNS-o-matic API to update the IP address."""
	_defaultUrl = "https://updates.opendns.com/nic/update?%s";
	_defaultRealm = "RESTRICTED"
	_getIpUrl = "myip.opendns.com"

	def __init__ (self, username = None, password = None, baseUrl = _defaultUrl, realm = _defaultRealm):
		DnsOMatic.__init__ (self, username, password, baseUrl, realm)		# Call parent's ctor



PROGRAM_VERSION = "0.20"
CONFIG_FILE = "/etc/dnsomatic.conf"
#CONFIG_FILE = "dnsomatic.conf"

# TODO
if True or __name__ == '__main__':
	from optparse import OptionParser

	class _Actions:
		GETIP = 0
		UPDATE = 1
		
	def getString (nodelist):
		"""Helper function to parse the XML configuration file."""
		if len (nodelist) >= 1 and nodelist[0].hasChildNodes ():
			ret = nodelist[0].childNodes[0].data.strip ()
		else:
			ret = None
		return ret

	def getStringList (nodelist):
		"""Helper function to parse the XML configuration file."""
		ret = []
		for node in nodelist:
			ret.append (node.childNodes[0].data.strip ())
		return ret

	def readConfig (configFile):
		"""Reads username and password from the configuration file."""
		from xml.dom.minidom import parse, parseString, getDOMImplementation
		
		try:
			dom = parse (configFile)
			for element in dom.getElementsByTagName ("config"):
				service = element.getAttribute ("service")
				if service == "dnsomatic":
					username = getString (element.getElementsByTagName ("username"))
					password = getString (element.getElementsByTagName ("password"))
					hostnames = getStringList (element.getElementsByTagName ("hostname"))
					break
		except IOError:
			# File not found
			print "Cannot open configuration file %s" % configFile
			username = None
			password = None
			hostnames = None

		return username, password, hostnames

	def getUsernameAndPassword (username_cmdline, password_cmdline, hostnames_cmdline, configfile):
		# Read username and password from configuration file, in case. The idea, here, is to use
		# values specified on the command line, filling in the missing ones with those taken from
		# the configuration file.
		if (username_cmdline is None or password_cmdline is None) and configfile != None:
			if configfile == '':
				configfile = CONFIG_FILE
			username_config, password_config, hostnames_config = readConfig (configfile)
		
			if username_cmdline is None:
				username = username_config
			else:
				username = username_cmdline
			if password_cmdline is None:
				password = password_config
			else:
				password = password_cmdline
			if hostnames_cmdline is None:
				if hostnames_config is not None and len (hostnames_config) > 0:
					hostnames = hostnames_config
				else:
					hostnames = None
			else:
				hostnames = hostnames_cmdline
		else:
			# Both username and password provided on the command line (or configfile not specified),
			# no need to read configfile
			username = username_cmdline
			password = password_cmdline
			# If username and password are provided on the command line, we assume the hostlist will be as well
			hostnames = hostnames_cmdline
		
		return username, password, hostnames

	def main ():
		cmdline_parser = OptionParser (usage = "Usage: %prog -G|-U [options]", description = "Update IP on the DNS-O-Matic service", version = "%s" % PROGRAM_VERSION)
		# Possible actions (i.e.: Operation modes)
		cmdline_parser.add_option ("-G", "--get", action = "store_const", dest = "action", const = _Actions.GETIP, help = "Retrieve the local IP", default = None)
		cmdline_parser.add_option ("-U", "--update", action = "store_const", dest = "action", const = _Actions.UPDATE, help = "Update the remote IP", default = None)
		# Other options
		cmdline_parser.add_option ("-u", "--username", action = "store", type = "string", dest = "username", help = "Specify username for DNS-O-Matic login (has precedence over configuration file)", default = None)
		cmdline_parser.add_option ("-p", "--password", action = "store", type = "string", dest = "password", help = "Specify password for DNS-O-Matic login", default = None)
		cmdline_parser.add_option ("-i", "--ip", action = "store", type = "string", dest = "ip", help = "Specify IP for update", default = None)
		cmdline_parser.add_option ("-c", "--configfile", action = "store", type = "string", dest = "configfile", help = "Read username and password from the specified file (Default: %s)" % CONFIG_FILE, default = CONFIG_FILE)
		cmdline_parser.add_option ("-H", "--hostname", action = "append", type = "string", dest = "hostnames", help = "Specify hostnames to update ", default = None)
		(options, args) = cmdline_parser.parse_args ()

		username, password, hostnames = getUsernameAndPassword (options.username, options.password, options.hostnames, options.configfile)

		# Proceed, according to the action
		if (options.action == None and ((username == None or username == '') or \
			(password == None or password == ''))) or \
			options.action == _Actions.GETIP:
			
			d = DnsOMatic ()
			ip = d.getCurrentLocalIP ()
			if ip != None:
				print "Your IP is: %s" % ip
				ret = 0
			else:
				print "Cannot retrieve IP"
				ret = 1
		elif options.action == _Actions.UPDATE or (options.action is None and ( \
			(username is not None and username != '') and \
			(password is not None and password != ''))):

			d = DnsOMatic (username, password)
			res = d.update (options.ip, hostnames)
			ret = 0		# Assume all went well
			if hostnames is None:
				(status, ip) = res[0]
				if status == "good":
					print "All IPs successfully updated to %s" % ip
				else:
					print "Cannot update any IP: %s" % status
					ret = 1
			else:
				for hostname, (status, ip) in zip (hostnames, res):
					if status == "good":
						print "IP for %s successfully updated to %s" % (hostname, ip)
					elif status == "alreadyok":
						print "No need to update IP for %s, already pointing to %s" % (hostname, ip)
					else:
						print "Cannot update IP for %s: %s" % (hostname, status)
						ret += 1
		else:
			ret = 255

		return ret

	sys.exit (main ())
