"""
Django PyBinder setup script.
"""

from setuptools import setup


# Getting description.
try:
    import pypandoc
except (IOError, ImportError):
    with open('README.md') as readme_file:
        description = readme_file.read()
else:
    description = pypandoc.convert('README.md', 'rst', format='markdown')


# Getting requirements.
with open('requirements.txt') as requirements_file:
    requirements = requirements_file.readlines()


setup(
    name='DjPyBinder',
    version='0.1.0',
    description='Dependency injection and management tool for Django',
    long_description=description,
    author='Roman Mogilatov',
    author_email='rmogilatov@gmail.com',
    maintainer='Roman Mogilatov',
    maintainer_email='rmogilatov@gmail.com',
    url='https://github.com/rmk135/djpybinder',
    license='BSD New',
    packages=['djpybinder'],
    zip_safe=True,
    install_requires=requirements,
    keywords=['Django',
              'Django dependency injection',
              'Django dependency injection container',
              'Django DI',
              'Django DIC',
              'Django Dependency injector',
              'Django Inversion of Control',
              'Django Inversion of Control container',
              'Django IoC',
              'Django IoC container'],
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Framework :: Django',
        # 'Programming Language :: Python :: 2',
        # 'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        # 'Programming Language :: Python :: 3',
        # 'Programming Language :: Python :: 3.2',
        # 'Programming Language :: Python :: 3.3',
        # 'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: Implementation :: CPython',
        # 'Programming Language :: Python :: Implementation :: PyPy',
        'Topic :: Software Development',
        'Topic :: Software Development :: Libraries',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ]
)
