# Django settings for regressiontests project.
import django

# Let testing know what version we're using
print "Using Django version: %s" % django.get_version()

# Use the new messages?
_MESSAGES_FRAMEWORK = (django.VERSION[:2] >= (1,2))

DEBUG = True
TEMPLATE_DEBUG = DEBUG

ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3', # Add 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'oracle'.
        'NAME': 'test.db',                      # Or path to database file if using sqlite3.
        'USER': '',                      # Not used with sqlite3.
        'PASSWORD': '',                  # Not used with sqlite3.
        'HOST': '',                      # Set to empty string for localhost. Not used with sqlite3.
        'PORT': '',                      # Set to empty string for default. Not used with sqlite3.
    }
}

# Old-school fallback (Django <= 1.1)
DATABASE_ENGINE = 'django.db.backends.sqlite3'
DATABASE_NAME = 'test.db'

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# On Unix systems, a value of None will cause Django to use the same
# timezone as the operating system.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Berlin'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'en-au'

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale
USE_L10N = True

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = ''

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = ''

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = '/media/'

# Make this unique, and don't share it with anybody.
SECRET_KEY = '+ljg9bcz6t7^9y8ppcxxg5#(%f1p#yj9ot%+e*n5n3y9kg=brm'

if django.VERSION < (1,2):
    TEMPLATE_LOADERS = ( 'django.template.loaders.app_directories.load_template_source',)
else:
    TEMPLATE_LOADERS = ( 'django.template.loaders.app_directories.Loader',)

MIDDLEWARE_CLASSES = [
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    #'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
]
if _MESSAGES_FRAMEWORK:
    MIDDLEWARE_CLASSES.append('django.contrib.messages.middleware.MessageMiddleware')

ROOT_URLCONF = 'regressiontests.urls'

TEMPLATE_DIRS = (
    # Put strings here, like "/home/html/django_templates" or "C:/www/django/templates".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
)

if django.VERSION < (1,2):
    TEMPLATE_CONTEXT_PROCESSORS = ["django.core.context_processors.auth"]
else:
    TEMPLATE_CONTEXT_PROCESSORS = ["django.contrib.auth.context_processors.auth"]

TEMPLATE_CONTEXT_PROCESSORS += [
    "django.core.context_processors.debug",
    "django.core.context_processors.i18n",
    "django.core.context_processors.media",
    'django.core.context_processors.request',
    ]
if _MESSAGES_FRAMEWORK:
    TEMPLATE_CONTEXT_PROCESSORS.append("django.contrib.messages.context_processors.messages")

INSTALLED_APPS = [
    'django.contrib.sites',
    'django.contrib.redirects',
    'rollyourown.seo',
    'userapp',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.admin',
    'django.contrib.flatpages',
]
if _MESSAGES_FRAMEWORK:
    INSTALLED_APPS.append('django.contrib.messages')

CACHE_BACKEND = 'dummy://'
# Enable when testing cache
#CACHE_BACKEND = "locmem://?timeout=30&max_entries=400"

# If south is available, add it
try:
    import south
    INSTALLED_APPS.append('south')
except ImportError:
    pass

SEO_MODELS = ('userapp',)

COVERAGE_MODULES = ('rollyourown.seo', 'userapp', 'flatpages.FlatPage')

try:
    from settings_local import *
except ImportError:
    pass
