# encoding:utf8

"""
    DragonPy - Dragon 32 emulator in Python
    =======================================

    :created: 2014 by Jens Diemer - www.jensdiemer.de
    :copyleft: 2014 by the DragonPy team, see AUTHORS for more details.
    :license: GNU GPL v3 or above, see LICENSE for more details.
"""

from __future__ import absolute_import, division, print_function


DRAGON32_BASIC_TOKENS = {
    0x80:"FOR",
    0x81:"GO",
    0x82:"REM",
    0x83:"'",
    0x84:"ELSE",
    0x85:"IF",
    0x86:"DATA",
    0x87:"PRINT",
    0x88:"ON",
    0x89:"INPUT",
    0x8a:"END",
    0x8b:"NEXT",
    0x8c:"DIM",
    0x8d:"READ",
    0x8e:"LET",
    0x8f:"RUN",
    0x90:"RESTORE",
    0x91:"RETURN",
    0x92:"STOP",
    0x93:"POKE",
    0x94:"CONT",
    0x95:"LIST",
    0x96:"CLEAR",
    0x97:"NEW",
    0x98:"DEF",
    0x99:"CLOAD",
    0x9a:"CSAVE",
    0x9b:"OPEN",
    0x9c:"CLOSE",
    0x9d:"LLIST",
    0x9e:"SET",
    0x9f:"RESET",
    0xa0:"CLS",
    0xa1:"MOTOR",
    0xa2:"SOUND",
    0xa3:"AUDIO",
    0xa4:"EXEC",
    0xa5:"SKIPF",
    0xa6:"DEL",
    0xa7:"EDIT",
    0xa8:"TRON",
    0xa9:"TROFF",
    0xaa:"LINE",
    0xab:"PCLS",
    0xac:"PSET",
    0xad:"PRESET",
    0xae:"SCREEN",
    0xaf:"PCLEAR",
    0xb0:"COLOR",
    0xb1:"CIRCLE",
    0xb2:"PAINT",
    0xb3:"GET",
    0xb4:"PUT",
    0xb5:"DRAW",
    0xb6:"PCOPY",
    0xb7:"PMODE",
    0xb8:"PLAY",
    0xb9:"DLOAD",
    0xba:"RENUM",
    0xbb:"TAB(",
    0xbc:"TO",
    0xbd:"SUB",
    0xbe:"FN",
    0xbf:"THEN",
    0xc0:"NOT",
    0xc1:"STEP",
    0xc2:"OFF",
    0xc3:"+",
    0xc4:"-",
    0xc5:"*",
    0xc6:"/",
    0xc7:"^",
    0xc8:"AND",
    0xc9:"OR",
    0xca:">",
    0xcb:"=",
    0xcc:"<",
    0xcd:"USING",

#Function tokens - all proceeded by 0xff to differentiate from operators
#Token  Function",
    0xff80:"SGN",
    0xff81:"INT",
    0xff82:"ABS",
    0xff83:"POS",
    0xff84:"RND",
    0xff85:"SQR",
    0xff86:"LOG",
    0xff87:"EXP",
    0xff88:"SIN",
    0xff89:"COS",
    0xff8a:"TAN",
    0xff8b:"ATN",
    0xff8c:"PEEK",
    0xff8d:"LEN",
    0xff8e:"STR$",
    0xff8f:"VAL",
    0xff90:"ASC",
    0xff91:"CHR$",
    0xff92:"EOF",
    0xff93:"JOYSTK",
    0xff94:"FIX",
    0xff95:"HEX$",
    0xff96:"LEFT$",
    0xff97:"RIGHT$",
    0xff98:"MID$",
    0xff99:"POINT",
    0xff9a:"INKEY$",
    0xff9b:"MEM",
    0xff9c:"VARPTR",
    0xff9d:"INSTR",
    0xff9e:"TIMER",
    0xff9f:"PPOINT",
    0xffa0:"STRING$",
    0xffa1:"USR",
}
