# -*- coding: iso-8859-1 -*-
"""
Multivariate Statistical Analysis model module.

Copyright (C) 2011 by Michael Sarahan

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
"""

from sqlalchemy import *
from sqlalchemy.orm import mapper, relation
from sqlalchemy import Table, ForeignKey, Column
from sqlalchemy.types import Integer, Unicode, Float, PickleType
from sqlalchemy.orm import relation, backref
from sqlalchemy.ext.declarative import declarative_base
from zope.sqlalchemy import ZopeTransactionExtension
from sqlalchemy.orm import scoped_session, sessionmaker

import numpy as np

DeclarativeBase=declarative_base()
DBSession = scoped_session(sessionmaker(
                             extension=ZopeTransactionExtension()))

__all__ = ['Result','PCA_Result']

class Result(DeclarativeBase):
    __tablename__ = 'results'
    
    #{ Columns
    id = Column(Integer, autoincrement=True, primary_key=True)
    name = Column(Unicode)
    atype = Column(Unicode)
    description = Column(Unicode)
    factors = Column(PickleType)
    scores = Column(PickleType)
    
    def __init__(self,name,atype,description=None,factors=None,scores=None):
        self.name=name
        self.atype=atype
        self.description=description
        self.factors=factors
        self.scores=scores

class PCA_Result(Result):
    __tablename__ = 'PCA_result'
    __mapper_args__ = {'polymorphic_identity': 'result_factors'}
    id = Column('id', Integer, ForeignKey('results.id'), 
                          primary_key=True)
    eigenvalues = Column(Pickletype)
    
    def __init__(self,name,atype,description=None,factors=None,scores=None,eigenvalues=None):
        Result.__init__(name,atype,description,factors,scores)
        self.eigenvalues=eigenvalues
