#!/usr/bin/env python
# The first line is critical, and must be exactly this

# Example Author block:
# Author: Michael Sarahan (msarahan@superstem.org), 23/02/2011 
# Copyright (c) 2011 Michael Sarahan

# Official copyright notice. EMAN2 is distributed under a joint GPL/BSD license. Please copy
# this statement from one of the other programs. You must agree to use this license if your
# code is distributed with EMAN2. While you may use your own institution for the copyright notice
# the terms of the GPL/BSD license permit us to redistribute it.

# import block, any necessary import statements
from EMAN2 import *
from optparse import OptionParser

# main() block. Each program will have a single function called main() which is executed when the
# program is used from the command-line. Programs must also be 'import'able themselves, so you
# must have main()
def main():

  progname = os.path.basename(sys.argv[0])
  usage = """%prog [options]

  This is the main documentation string for the program, which should define what it does an how to use it.
  """

  # You MUST use OptionParser to parse command-line options
  parser = OptionParser(usage=usage,version=EMANVERSION)

  parser.add_option("--input", type="string", help="The name of the input particle stack", default=None)
  parser.add_option("--output", type="string", help="The name of the output particle stack", default=None)
  parser.add_option("--oneclass", type="int", help="Create only a single class-average. Specify the number.",default=None)
  parser.add_option("--transmax",type="float",help="The maximum translational distance in any direction. Default is 5.0",default=5.0)
  parser.add_option("--transmin",type="float",help="The minimum translational distance in any direction. Default is -5.0",default=-5.0)
  parser.add_option("--rotmax",type="float",help="The maximum rotation angle applied. Default is 360.0",default=360.0)
  parser.add_option("--rotmin",type="float",help="The minimum rotation angle applied. Default is 0.0",default=0.0)
  parser.add_option("--verbose", "-v", dest="verbose", action="store", metavar="n",type="int", default=0, help='verbose level [0-9], higher number means higher level of verboseness')

  (options, args) = parser.parse_args()

  # Now we have a call to the function which actually implements the functionality of the program
  # main() is really just for parsing command-line arguments, etc.  The actual program algorithms 
  # must be implemented in additional functions so this program could be imported as a module and
  # the functionality used in another context

  E2n=E2init(sys.argv)

  data=EMData.read_images(options.input)
  # average the input images to get a reference image.
  ref =EMData.read_images(options.input)

  results=myfunction(data,options.oneclass)

  for im in results: im.write_image(options.output,-1)

  E2end(E2n)

def myfunction(data,oneclass):
  # do some stuff
  ret = [i*5.0 for i in data]

  return ret

# This block must always be the last thing in the program and calls main()
# if the program is executed, but not if it's imported
if __name__ == "__main__":
    main()
