 #!/usr/bin/env python
#
# This script mostly generates SPIDER input files and then tells SPIDER to run.
# It is advantageous to SPIDER alone for batch processing.

import numpy as np
from subprocess import call
import time
import spiconvert
from glob import glob
import Image
import db_model as db
from db_model import *
import shutil
import os

from IPython.Shell import IPShellEmbed
ipshell = IPShellEmbed()

spiTemplateDir=os.path.dirname(db.__file__)+'/templates/'
spiderExec=os.popen("which spider").readlines()[0][:-1]

def mkListFile(start=None,end=None,numlist=None,outfile='listparticles.spi'):
    f=open(outfile,'w')
    print>>f, ' ;spi/spi\t', time.strftime('%d-%b-%Y AT %H:%M:%S\t'), outfile
    i=1
    if start:
        for num in range(int(start),int(end)+1):
            print >>f,i,1,num
            i+=1      
    else:
        for num in numlist:
            print>>f, i,1,num
            i+=1
    return outfile

def combine_files():
    i=1
    call(['rm','ali/all*'])
    imlist=glob('ali/*.spi')
    imlist.sort()
    for im in imlist:
        call(['cp',im,'ali/all_wi%05i.spi'%i])
        i=i+1
        try:
            subimg=SubImage.query.filter(SubImage.aliases.contains(im)).one()
            subimg.aliases=subimg.aliases+',ali/all_wi%05i.spi'%i
        except:
            pass
        

def spiderCorAn(infile='all',eigenvectors=50):
    f=open('capcatmp.spi','w')
    
    if infile is not 'all':
        infile=infile[:-4]
    else:
        combine_files()
    wipath='ali/%s_wi'%infile
    selectionDoc=mkListFile(1,len(glob(wipath+"*.spi")),outfile='listparticles_%s.spi'%infile)
    imtest = Image.open('ali/%s_wi%05i.spi'%(infile,1))
    dim = imtest.size[0]
    maskRadius=dim/3
    if eigenvectors > len(glob(wipath+"*.spi"))-1:
        eigenvectors=len(glob(wipath+"*.spi"))-1
    
    print>>f, '; This file automatically generated by SpiderControl.py'
    print>>f, '; Written March 2010, Mike Sarahan, UC Davis\n\n'
    print>>f, '; -------------Parameters-----------------'
    print>>f, 'x65=%i  ;image dimension (square)'%dim
    print>>f, 'x32=%i  ;particle radius (pixels)'%maskRadius
    print>>f, 'x29=0.05 ;additive constant for correspondence analysis'
    print>>f, 'x27=%i ; number of eigenvectors to calculate\n\n'%eigenvectors
    print>>f, '; -------------Inputs-----------------'
    print>>f, 'FR G'
    print>>f, '[particles]'+wipath+'*'*5+'      ; particle file-pattern'
    print>>f, 'FR G'
    print>>f, '[selection_doc]%s\n\n'%selectionDoc[:-4]
    print>>f, '; ------------------ Outputs ------------------'
    print>>f, 'FR G'
    print>>f, '[ca_dir]CA_%s        ; output directory'%infile
    
    spiTemplate=open(spiTemplateDir+'ca-pca.footer','r')
    f.write(spiTemplate.read())
    f.close()
    output=call(['%s spi/spi @capcatmp'%spiderExec],shell=True)
    return output
    
def spiderCrop(template,exptimg,noisefile=None,neighborhood=None,numpeaks=1000,maskRadius=0.8):
    #import cv
    #cv_template=cv.LoadImage(template,0)
    #cv_exptimg=cv.LoadImage(exptimg,0)
    #xcorr(cv_template,cv_exptimg,save=True)
    #spiconvert.run('CCres.png','CC_%s.spi'%exptimg[:-4])
    if not os.path.exists('ali'):
        os.mkdir('ali')
    # the next 2 ifs check whether the input images are SPIDER images, and
    # converts them if necessary.
    if exptimg[-3:] is not 'spi':
        spiconvert.run(exptimg,'%sspi'%exptimg[:-3])
    if template[-3:] is not 'spi':
        spiconvert.run(template,'%sspi'%template[:-3])
    
    templateimg=Image.open(template)
    templatesize=int(templateimg.size[0])
   
    if not noisefile or not os.path.isfile('noiseref.spi'):
        #expttmp=Image.open(exptimg)
        #topleft=expttmp.size[0]/2+-199
        #exptcrop=expttmp.crop((topleft,topleft,400,400))
        #exptcrop.save('exptcrop.spi')
        
        f=open('noisetmp.spi','w')
        print>>f, "; NOISE.BAT  Extract a series of particle-sized windows from a"
        print>>f, "; micrograph, compare their standard deviations to obtain a noise image."
        print>>f, ";"
        print>>f, "; An initial set of windows is sorted by their standard deviations. Only"
        print>>f, "; an area the size of the large window, in the center of the micrograph,"
        print>>f, "; is examined."
        print>>f, "; From the top 30 windows (lowest std devs), a second measurement is made"
        print>>f, "; of the local Std dev of each quadrant of each window, which are then"
        print>>f, "; sorted by this second measure. "
        print>>f, "; This set of images should be viewed in Web to select the final noise file."
        print>>f, ";"
        print>>f, "; Inputs:"
        print>>f, ";   input image (in spider format)"
        print>>f, ";   x95 : size of the large window (area to be examined)"
        print>>f, ";   x96 : size of the small windows (can be particle-sized)"
        print>>f, ";   x98 : delete flag. If x98 = 1, temporary doc files are deleted."
        print>>f, ";"
        print>>f, "; Outputs:"
        print>>f, ";   template for output images : it may include a directory path"
        print>>f, "x95 = 400 ; diameter of the large window"
        print>>f, "x96 = %i ; diameter of the small window"%templatesize
        print>>f, "x98 = 1  ; 1 = delete temp doc files, 0 = don't delete"
        
        print>>f, "FI [imgh],[imgw]"
        print>>f, "%s"%exptimg
        print>>f, "2,12"
        
        print>>f, "WI"
        print>>f, "%s"%exptimg[:-4]
        print>>f, "exptcrop"
        print>>f, "400,400"
        print>>f, "[imgw]/2-199,[imgh]/2-199"
                
        print>>f, "@noise_p[x95,x96,x98]"
        print>>f, "exptcrop       ; input image"
        print>>f, "noise    ; output noise windows"
        print>>f, "EN D"
        f.close()     
        output=call(['%s spi/spi @noisetmp'%spiderExec],shell=True)     
        shutil.copy('noise001.spi','noiseref.spi')
        noisefile='noiseref'
    
    if not neighborhood:
        neighborhood=templateimg.size[0]/10
   
    shutil.copy(template[:-3]+'spi','tmpref1.spi')
    shutil.copy(template[:-3]+'spi','tmpref2.spi')
    # These 2 check if the filename includes the file extension, and removes it if they do.
    # It's redundant given the above 2, but...
    if exptimg[-4] is '.':
        exptimg=exptimg[:-4]
    if template[-4] is '.':
        template=template[:-4]
    spiTemplate=open(spiTemplateDir+'pickparticle.footer','r')

    f=open('cctmp.spi','w')
    
    print>>f, ";Auto-generated script.  Input is written by the SpiderControl.py script"
    print>>f, '; This file automatically generated by SpiderControl.py'
    print>>f, '; Written March 2010, Mike Sarahan, UC Davis'
    print>>f, '; Script functionality comes from:'
    print>>f, "; pickparticle.bat                           BIMAL RATH : FEB 2003"
    print>>f, ';'
    print>>f, '; PICKS PARICLES FROM A MICROGRAPH. INPUTS ARE A MICROGRAPH AND THE 3D VOLUME'
    print>>f, '; OF THE PARTICLE THAT WE ARE SEARCHING FOR ITS PROJECTION INSIDE THE MICROGRAPH.'
    print>>f, "; USES A NON-ISOTROPIC MASK. USED ALAN ROSEMAN'S FORMULATION FOR CALCULATING "
    print>>f, '; LOCAL CROSS-CORRELATION COEFFICIENTS(ULTRAMICROSCOPY 2003).'

    print>>f, '; MAKE SURE THAT BOTH THE MICROGRAPH AND THE 3D VOLUME OF THE PARTICLE' 
    print>>f, '; ARE OF SAME MAGNIFICATION (1 PIXEL = "N" NANOMETER) '

    print>>f, '; READ INPUT FILES'

    print>>f, 'FR G'
    print>>f, '[micfile]%s'%exptimg

    print>>f, 'FR G' 
    print>>f, '[partvol]%s_v'%template
    print>>f, 'FR G'
    print>>f, '[noisefile]%s'%noisefile

    print>>f, 'FR G'
    print>>f, '; WINDOWED PARTICLE SERIES (OUTPUT) TEMPLATE'
    print>>f, '[winpart]ali/%s_wi'%exptimg
    
    print>>f, 'FR G'
    print>>f, '; CIRCULAR MASK RADIUS'
    print maskRadius
    print>>f, '[psize]%f'%maskRadius
    
    print>>f, 'FR G'
    print>>f, '[v93]=1 ;Starting particle number hardcoded to 1'

    print>>f, '; Output FILE WITH EULERIAN ANGLES AND INFO FROM PEAK SEARCH FILE'
    print>>f, 'FR G'
    print>>f, '[posdoc]spots_%s'%exptimg

    print>>f, '[v41]=0  ; Do not use selection file'
    
    print>>f, ';PHI, START ANGLE'
    print>>f, '[v65]=0'
    print>>f, ';PHI, END ANGLE (+VE)'
    print>>f, '[v68]=0'
    print>>f, ';PHI, SEARCH STEP SIZE (+VE)'
    print>>f, '[v74]=1'

    print>>f, '; AVOID DIVISION BY ZERO'
    print>>f, 'IF ([v74].EQ.0) THEN'
    print>>f, '  [v74] = 1'
    print>>f, 'ENDIF'

    print>>f, ';Theta, START ANGLE'
    print>>f, '[v66]=-5'
    print>>f, ';Theta, END ANGLE (+VE)'
    print>>f, '[v69]=5'
    print>>f, ';Theta, SEARCH STEP SIZE (+VE)'
    print>>f, '[v75]=0.1'

    print>>f, ';Psi, START ANGLE'
    print>>f, '[v67]=0'
    print>>f, ';Psi, END ANGLE (+VE)'
    print>>f, '[v73]=0'
    print>>f, ';Theta, SEARCH STEP SIZE (+VE)'
    print>>f, '[v76]=1'    

    print>>f, '; INTERPOLATION FACTOR '
    print>>f, '[v89]=1 '

    print>>f, '; # OF PEAKS TO BE SEARCHED' 
    print>>f, '[v95]=%i '%numpeaks

    print>>f, '; NEIGHBOURHOOD DISTANCE FOR EXCLUSION' 
    print>>f, '[v35]=%s'%neighborhood

    print>>f, '[v35] = [v35]/[v89]'

    print>>f, '; FIND IF A SYMMETRIC MASK WILL BE USED.'
    print>>f, '[v51]=1 ; Use a symmetric mask'

    #print>>f, 'FR G'
    #print>>f, '[IMAGE]%s'%exptimg
    #print>>f, 'FR G'
    #print>>f, '[REF]%s\n\n'%template
    #print>>f, 'FR G'
    #print>>f, '[CCFILE]CC_%s.spi\n\n'%exptimg[:-4]
    f.write(spiTemplate.read())
    
    f.close()
    
    output=call(['%s spi/spi @cctmp'%spiderExec],shell=True)
    return output

def spiderHeirarchical(file,eigenfactors=10,nclusters=10):
    f=open('hctmp.spi','w')
    if file is not 'all':
        file=file[:-4]
    print eigenfactors
    print>>f, "; CLUSTERS USING WARD'S METHOD"
    print>>f, '; This file automatically generated by SpiderControl.py'
    print>>f, '; Written March 2010, Mike Sarahan, UC Davis'
    print>>f, '; --------- Parameters ---------'
    print>>f, 'x27 = %i    ; number of eigenfactors to use'%eigenfactors
    print>>f, '; ----------- Inputs -----------'
    print>>f, 'fr l'
    print>>f, '[cas_prefix]CA_%s/cas      ; correspondence-analysis output prefix'%file
    print>>f, '; ---------- Outputs ----------'
    print>>f, 'fr l'
    print>>f, '[class_dir]HC_%s     ; output directory'%file
    spiTemplate=open(spiTemplateDir+'hierarchical.footer','r')
    f.write(spiTemplate.read())
    f.close()
    output=call(['%s spi/spi @hctmp'%spiderExec],shell=True)
    print eigenfactors    
    f=open('clatmp.spi','w')
    print>>f, "; CLUSTERS USING DIDAY'S METHOD"
    print>>f, '; This file automatically generated by SpiderControl.py'
    print>>f, '; Written March 2010, Mike Sarahan, UC Davis'
    print>>f, '; --------- Parameters ---------'
    print>>f, 'x27 = %i    ; number of eigenfactors to use'%eigenfactors
    print>>f, '; ----------- Inputs -----------'
    print>>f, 'fr l'
    print>>f, '[cas_prefix]CA_%s/cas      ; correspondence-analysis output prefix'%file
    print>>f, '; ---------- Outputs ----------'
    print>>f, 'fr l'
    print>>f, '[class_dir]CLA_%s     ; output directory'%file
    spiTemplate=open(spiTemplateDir+'cluster.footer','r')
    f.write(spiTemplate.read())
    f.close()
    
    output=call(['%s spi/spi @clatmp'%spiderExec],shell=True)
    
    f=open('claavgtmp.spi','w')
    print>>f, "; CLASS AVERAGES FROM CLUSTERS USING DIDAY'S METHOD"
    print>>f, '; This file automatically generated by SpiderControl.py'
    print>>f, '; Written March 2010, Mike Sarahan, UC Davis'
    print>>f, '; --------- Parameters ---------'
    print>>f, 'x20 = %i    ; number of clusters '%nclusters
    print>>f, '; ----------- Inputs -----------'
    print>>f, 'fr l'
    print>>f, '[class_dir]CLA_%s     ; input/output directory'%file
    print>>f, 'fr l'
    print>>f, '[dendrogram_doc][class_dir]/docdendro     ; dendrogram input'
    print>>f, 'fr l'
    print>>f, '[particles]ali/%s_wi*****     ; dendrogram input'%file
    spiTemplate=open(spiTemplateDir+'classavg.footer','r')
    f.write(spiTemplate.read())
    f.close()
    
    output=call(['%s spi/spi @claavgtmp'%spiderExec],shell=True)
    
    f=open('hcavgtmp.spi','w')
    print>>f, "; CLASS AVERAGES FROM CLUSTERS USING DIDAY'S METHOD"
    print>>f, '; This file automatically generated by SpiderControl.py'
    print>>f, '; Written March 2010, Mike Sarahan, UC Davis'
    print>>f, '; --------- Parameters ---------'
    print>>f, 'x20 = %i    ; number of clusters '%nclusters
    print>>f, '; ----------- Inputs -----------'
    print>>f, 'fr l'
    print>>f, '[class_dir]HC_%s     ; input/output directory'%file
    print>>f, 'fr l'
    print>>f, '[dendrogram_doc][class_dir]/docdendro     ; dendrogram input'
    print>>f, 'fr l'
    print>>f, '[particles]ali/%s_wi*****     ; dendrogram input'%file
    spiTemplate=open(spiTemplateDir+'classavg.footer','r')
    f.write(spiTemplate.read())
    f.close()
    
    output=call(['%s spi/spi @hcavgtmp'%spiderExec],shell=True)    
    return output

def maskfiles(files,masksize=(2/6.)):
    spitmp=open('spimask.spi','w')
    nparticles=len(files)
    for n in range(len(files[0])):
        try:
            int(files[0][:-4][-n:])
            numlength=n
            prefix=files[0][:-4][:-n]
        except:
            pass
    print numlength
    if not os.path.exists('mask'):
        os.mkdir('mask')
    print>>spitmp, "; Script to mask files."
    print>>spitmp, ";"
    print>>spitmp, 'FR G'
    print>>spitmp, '[inprefix]%s'%prefix
    print>>spitmp, 'FR G'
    print>>spitmp, '[outprefix]mask/%s'%prefix
    print>>spitmp, 'FR G'
    print>>spitmp, '[nparticles]%i'%nparticles
    print>>spitmp, '[v666]=1'
    print>>spitmp, 'FI [particlesize]'
    print>>spitmp, '[inprefix]{%s[v666]}'%('*'*numlength)
    print>>spitmp, '2'
    print>>spitmp, 'DO [v666] = 1,[nparticles]'
    print>>spitmp, ''    
    print>>spitmp, 'MA'
    print>>spitmp, '[inprefix]{%s[v666]}'%('*'*numlength)
    print>>spitmp, '[outprefix]{%s[v666]}'%('*'*numlength)
    print>>spitmp, '[particlesize]*%f,0.0'%masksize
    print>>spitmp, 'D'
    print>>spitmp, 'E'
    print>>spitmp, '(0)'
    print>>spitmp, '[particlesize]/2+1,[particlesize]/2+1'
    print>>spitmp, ''
    print>>spitmp, 'ENDDO'
    print>>spitmp, 'EN'
    spitmp.close()
    output=call(['%s spi/spi @spimask'%spiderExec],shell=True)

def readEMAN2ptcls(fname,template=None,maskRadius=None):
    """
    Reads a SPIDER stack file output from EMAN2.  Also reads box file for
    particle coordinates.  Shift aligns particles using SPIDER.
    It works much better if you give it a good template.  Set mask to True
    to make a circular mask about the center of the data.
    """
    if not maskRadius:
        maskRadius=1.5
    cwd=os.getcwd()
    if len(ParentImage.query.filter_by(filename=fname).all()) is 0:
        p=ParentImage(location=cwd,filename=fname,data=np.asarray(Image.open(fname)))
    if not os.path.exists('ali'):
        os.mkdir('ali')
    coordfile=open(fname[:-3]+'box','r')
    coords=coordfile.readlines()
    nparticles=len(coords)
    if not template:
        template='*'
    spitmp=open('spiextractor.spi','w')
    print>>spitmp, "; Script to pull individual unit cells from a spider stack file."
    print>>spitmp, ";"
    print>>spitmp, 'FR G'
    print>>spitmp, "[cropfile]%s"%fname[:-4]+"_ptcls"
    print>>spitmp, 'FR G'
    print>>spitmp, '[outprefix]%s'%'ali/'+fname[:-4]+'_wi'
    print>>spitmp, 'FR G'
    print>>spitmp, '[nparticles]%i'%nparticles
    print>>spitmp, '[v666]=1'
    print>>spitmp, 'FI [particlesize]'
    print>>spitmp, '[cropfile]@{****[v666]}'
    print>>spitmp, '2'
    print>>spitmp, '[particlesize]=[particlesize]/2'
    print>>spitmp, 'DO [v666] = 1,[nparticles]'
    print>>spitmp, ''
    print>>spitmp, '  CP'
    #print>>spitmp, '  FI'
    print>>spitmp, '  [cropfile]@{****[v666]}'
    print>>spitmp, '  [outprefix]{*****[v666]}'
    print>>spitmp, ''
    print>>spitmp, 'ENDDO'
    
    print>>spitmp, 'DE A'
    print>>spitmp, '%s_RDOC001'%fname[:-4]
    print>>spitmp, 'DE A'
    print>>spitmp, '%s_RAVGS001'%fname[:-4]
    
    print>>spitmp, 'AP SR'
    print>>spitmp, '[outprefix]*****'
    print>>spitmp, '1-[nparticles]'
    print>>spitmp, '[particlesize]'
    print>>spitmp, '[particlesize]/3,[particlesize]/2'
    print>>spitmp, '%s'%template
    print>>spitmp, '%s_RAVGS***'%fname[:-4]
    print>>spitmp, '%s_RDOC***'%fname[:-4]
    print>>spitmp, 'EN'
    spitmp.close()
    output=call(['%s spi/spi @spiextractor'%spiderExec],shell=True)
    
    spitmp=open('spialigner.spi','w')
    print>>spitmp, "; Script to align unit cells from a spider stack file."
    print>>spitmp, ";"
    print>>spitmp, 'FR G'
    print>>spitmp, "[cropfile]%s"%fname[:-4]+"_ptcls"
    print>>spitmp, 'FR G'
    print>>spitmp, '[outprefix]%s'%'ali/'+fname[:-4]+'_wi'
    print>>spitmp, 'FR G'
    print>>spitmp, '[nparticles]%i'%nparticles
    print>>spitmp, '[v666]=1'
    print>>spitmp, 'FI [particlesize]'
    print>>spitmp, '[cropfile]@{****[v666]}'
    print>>spitmp, '2'
    print>>spitmp, '[particlesize]=[particlesize]/2'
    rdocs=len(glob('%s_RDOC*'%fname[:-4])) 
    print>>spitmp, 'DO [v666] = 1,[nparticles]'
    print>>spitmp, '  UD IC [v666],[ang],[x],[y]'
    print>>spitmp, '  %s_RDOC%03i'%(fname[:-4],rdocs)
    print>>spitmp, ''        
    print>>spitmp, '  SH'
    print>>spitmp, '  [cropfile]@{****[v666]}'
    print>>spitmp, '  _32'
    print>>spitmp, '  [x],[y]'
    print>>spitmp, ''    
    #print>>spitmp, '  FI [min],[max]   ; File info. operation '       
    #print>>spitmp, '  _32      ; Input file '
    #print>>spitmp, '  8,7              ; Min and max location in header'  
    #print>>spitmp, ''
    print>>spitmp, '  MA'
    print>>spitmp, '  _32'
    print>>spitmp, '  [outprefix]{*****[v666]}'
    print>>spitmp, '  [particlesize]*%f,0.0'%maskRadius
    print>>spitmp, '  D'
    print>>spitmp, '  E'
    print>>spitmp, '  (0)'
    print>>spitmp, '  [particlesize]+1,[particlesize]+1'
    print>>spitmp, ''    
    print>>spitmp, 'ENDDO'    
    #print>>spitmp, 'FI '
    
    #print>>spitmp, 'AR               ; Arithmetic operation'            
    #print>>spitmp, '_32      ; Input file'                      
    #print>>spitmp, '[outprefix]_sc{*****[v666]}          ; Output file'                     
    #print>>spitmp, '255 * (P1-[min]) / ([max]-[min]) '

    print>>spitmp, 'EN'
    spitmp.close()
    output=call(['%s spi/spi @spialigner'%spiderExec],shell=True)
    #addSubImagesToDB(fname,spotfile=fname[:-3]+'box')


# Reads eigenvalues (image coordinates) from SPIDER.  Obsolete.
def readIMC(infile):
    f=open('CA_'+infile[:-4]+'/cas_IMC.spi')
    lines=f.readlines()
    parent=ParentImage.query.filter_by(filename=infile).one()
    subimg=SubImage.query.filter_by(parent=parent)
    fnum=1
    ct=1
    for line in lines[1:]:
        vars=line.split()
        #ipshell()
        s=subimg.filter_by(number = fnum).one()
        if vars[-1]=='1.0000':
            fvars=[float(var) for var in vars[:-4]]
            for fvar in fvars:
                ev=CA_Eigenvector.query.filter_by(id=ct).one()
                CA_Eigenvalue(subimage=s,value=fvar,eigenvector=ev)
                ct=ct+1
            fnum=int(float(vars[-2]))+1
            ct=1
        else:
            fvars=[float(var) for var in vars]
            for fvar in fvars:
                ev=CA_Eigenvector.query.filter_by(id=ct).one()
                CA_Eigenvalue(subimage=s,value=fvar,eigenvector=ev)
                ct=ct+1
    session.commit()


# Used to read eigenimages that are output by SPIDER.  Obsolete.
def readEigenvectors(infile):
    if infile is 'all':
        parents=ParentImage.query.all()
        nparents=len(parents)
        os.chdir('CA_all')
    else:
        nparents=1
        pset=m.ParentSet.query.filter(m.ParentSet.parents.any(
             m.ParentImage.filename==infile
             )).filter_by(nparents=nparents).all()
        if not pset:
            pset=m.ParentSet(parents=[parent],nparents=1)
            caset=m.CA_Eigenvectors(pset=pset)
        parent=m.ParentImage.query.filter_by(filename=infile).one()
        subimages=m.SubImage.query.filter_by(parent=parent).all()
        avgimg=np.sum(np.array([subimage.data for subimage in subimages]),axis=0)/float(len(subimages))
=       pset.avgImage=avgimg
        os.chdir('CA_'+infile[:-4])
        
    flist=glob('eigenimg*')
    flist.sort()
    for f in flist:
        CA_Eigenvector(eigenvector=np.asarray(Image.open(f)))
    os.chdir('..')
    session.commit()
            
def addSubImagesToDB(parentImageFile,spotfile=None):
    parent=ParentImage.query.filter(ParentImage.filename == parentImageFile).one()
    imglist=glob('ali/%s*spi'%parentImageFile[:-4])
    imglist.sort()
    eximg=Image.open(imglist[0])
    lineoffset=0
    if not spotfile:
        spotfile='spots_%s.spi'%parentImageFile[:-4]
        lineoffset=2
    f=open(spotfile)
    lines=f.readlines()
    i=0
    for line in lines[lineoffset:len(imglist)+lineoffset]:
        #ipshell()
        line=line.split()
        if lineoffset ==2:  #Spider file
            x=np.round(float(line[2]),0)
            y=np.round(float(line[3]),0)
            s=SubImage(x=x,y=y,data=np.asarray(Image.open(imglist[i]),dtype=np.float32),aliases=imglist[i],number=int(line[0]))
        elif lineoffset==0:  #EMAN file
            x=int(line[0])+eximg.size[0]/2
            yinv=parent.data.shape[1]
            y=yinv-int(line[1])-eximg.size[1]/2
            s=SubImage(x=x,y=y,data=np.asarray(Image.open(imglist[i])),aliases=imglist[i],number=i+1)
        s.parent=parent
        i=i+1
    session.commit()
            
if __name__=='__main__':
    # This section was for testing.  You can change the infiles & templates
    # to play with it.
    #infiles=['008_HAADF_5M_Mag_Si_shear.tif',
    #         '013_HAADF_2M_Mag_Si_Third_Cond_set_shear.tif',
    #         '022_vHAADF_5M_Mag_Si_Maybe_Single_Bi_shear.tif']
    infiles=glob('23*.tif')
    template=glob('template*.png')[0]
    initializeDB(clear=True,debug=False)
    cwd=os.getcwd()
    for infile in infiles:
        ParentImage(location=cwd,filename=infile)
        spiderCrop(template,infile) # Uncomment when regenerating crops needed.
        addSubImagesToDB(infile)
        #spiderCorAn(infile)
        #readEigenvectors(infile)
        #readIMC(infile)
    #spiderCorAn()
    
