from elixir import *
from sqlalchemy.orm import relation
from sqlalchemy import ForeignKeyConstraint
import os

def initializeDB(dbName='imageDB.sqlite',clear=False,debug=False):
    # Clears the database
    if os.path.exists(dbName) and clear:
        os.remove(dbName)

    metadata.bind="sqlite:///"+dbName
    
    if debug:
        metadata.bind.echo=True
    
    # Creates the database
    setup_all()
    create_all()

class ParentImage(Entity):
    """
    Location is the filename on disk.  Data is the image array in string form,
    from np.array.tostring()
    """
    location=Field(String,primary_key=True)
    filename=Field(String,primary_key=True)
    data=Field(PickleType)
    subimages=OneToMany('SubImage')
    parentset=ManyToMany('ParentSet')
    
    def __repr__(self):
        return '<ParentImage "%s">'% (self.filename)
    
    def getfilename(self):
        return self.filename

class ParentSet(Entity):
    using_options(tablename='parentset')
    parents=ManyToMany('ParentImage')
    nparents=Field(Integer)
    avgImage=Field(PickleType)

class PCA_Factors(Entity):
    factors=OneToMany('PCA_Factor')   
    using_table_options(ForeignKeyConstraint(['id'], ['parentset.id']))
    pset = GenericProperty(relation(ParentSet))
    
class ICA_Factors(Entity):
    factors=OneToMany('ICA_Factor')
    using_table_options(ForeignKeyConstraint(['id'], ['parentset.id']))
    pset = GenericProperty(relation(ParentSet))
    
class PCA_Factor(Entity):
    """
    Each field is a string representation of the numpy array.  You need to do 
    np.fromstring() on the output to retrieve the factor.  Each record is
    a vector - so rows here are what would be columns from the PCA analysis.
    """
    using_options(tablename='pcafac')
    fset=ManyToOne('PCA_Factors',colname=['parentset_id'])
    factor=Field(PickleType)
    scores=OneToMany('PCA_Score')

class ICA_Factor(Entity):
    """
    Each field is a string representation of the numpy array.  You need to do 
    np.fromstring() on the output to retrieve the factor.  Each record is
    a vector - so rows here are what would be columns from the PCA analysis.
    """
    using_options(tablename='icaevec')
    fset=ManyToOne('ICA_Factors',colname=['parentset_id'])
    factor=Field(PickleType)
    scores=OneToMany('ICA_Score')

class SubImage(Entity):
    """
    Composite primary key - parent and x,y coordinate determine a unique subimage
    """
    parent=ManyToOne('ParentImage',primary_key=True)
    x=Field(Integer,primary_key=True)
    y=Field(Integer,primary_key=True)
    data=Field(PickleType)
    PCA_scores=OneToMany('PCA_Score')
    ICA_scores=OneToMany('ICA_Score')
    number=Field(Integer)
    aliases=Field(String)
    #rat=Field(Float)
    #ratstd=Field(Float)
    
    #def __repr__(self):
    #    return '<SubImage from "%s" with %i file aliases>'% (self.parent,len(self.aliases.split(',')))
    
class PCA_Score(Entity):
    """
    Each field is a string representation of the numpy array.  You need to do 
    np.fromstring() on the output to retrieve the factor.  Each record is
    a vector - so rows here are what would be columns from the PCA analysis.
    """
    subimage = ManyToOne('SubImage')
    factor=ManyToOne('PCA_Factor')
    score=Field(Float)  
    
class ICA_Score(Entity):
    """
    Each field is a string representation of the numpy array.  You need to do 
    np.fromstring() on the output to retrieve the factor.  Each record is
    a vector - so rows here are what would be columns from the PCA analysis.
    """
    subimage = ManyToOne('SubImage')
    factor=ManyToOne('ICA_Factor')
    score=Field(Float)
