import cv
import numpy as np
import Image

def read(flist):
    try:
        imsample=cv.LoadImage(flist[0])
        colLength=imsample.width*imsample.height
        PIL=False
    except:
        imsample=Image.open(flist[0])
        colLength=imsample.size[0]*imsample.size[1]
        PIL=True
    data_array=np.zeros((colLength,len(flist)))
    i=0
    ctr=xrange(colLength)

    if PIL:
        for image in flist:
            data=np.array(Image.open(image)).reshape(colLength)
            for ct in ctr:
                data_array[ct,i]=data[ct]
            i+=1
    else:
        for image in flist:
            data=np.array(cv2array(cv.LoadImage(image,0))).reshape(colLength)
            for ct in ctr:
                data_array[ct,i]=data[ct]
            i+=1       

    return data_array
    
#Following 2 functions adapted from Minh-Tri Pham's ctypes_opencv wrapper.

def cv2array(im):
    depth2dtype = {
        cv.IPL_DEPTH_8U: 'uint8',
        cv.IPL_DEPTH_8S: 'int8',
        cv.IPL_DEPTH_16U: 'uint16',
        cv.IPL_DEPTH_16S: 'int16',
        cv.IPL_DEPTH_32S: 'int32',
        cv.IPL_DEPTH_32F: 'float32',
        cv.IPL_DEPTH_64F: 'float64',
    }
  
    arrdtype=im.depth
    a = np.fromstring(
         im.tostring(),
         dtype=depth2dtype[im.depth],
         count=im.width*im.height*im.nChannels)
    a.shape = (im.height,im.width,im.nChannels)
    return a
    
def array2cv(a):
    dtype2depth = {
        'uint8':   cv.IPL_DEPTH_8U,
        'int8':    cv.IPL_DEPTH_8S,
        'uint16':  cv.IPL_DEPTH_16U,
        'int16':   cv.IPL_DEPTH_16S,
        'int32':   cv.IPL_DEPTH_32S,
        'float32': cv.IPL_DEPTH_32F,
        'float64': cv.IPL_DEPTH_64F,
    }
    try:
        nChannels = a.shape[2]
    except:
        nChannels = 1
    cv_im = cv.CreateImageHeader((a.shape[1],a.shape[0]), dtype2depth[str(a.dtype)], nChannels)
    cv.SetData(cv_im, a.tostring(),a.dtype.itemsize*nChannels*a.shape[1])
    return cv_im

if __name__=='__main__':
    flist=['','']