#!/usr/bin/env python

"""
Copyright (C) 2011 by Michael Sarahan

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
"""

import numpy as np
from glob import glob
from utils.msa_rpy import ica
    
import matplotlib.pyplot as plt
#from mpl_toolkits.mplot3d import Axes3D
#from matplotlib.collections import PolyCollection
#from matplotlib.colors import colorConverter
from spectrumFilters import smooth
from scipy import integrate
import os,sys
  
def savetxt(data,energydata,fname):
  if data.shape[0]==energydata.shape[0]:
    energydata=energydata.reshape((-1,1))
  try:
    cdata=np.hstack((energydata,data))
    
  except:
    print "data array size %s does not match energy array size %s"%(data.shape,energydata.shape)
    sys.exit()
  np.savetxt(fname,cdata)
    
def align_data_dualEELS(highlossfolder,lowlossfolder,specnumber):
  """
  Corrects for beam energy instability by subtracting the energy of ZLP max
  from the corresponding high loss energy calibration.
  """
  from pandas import Series, DataFrame
  
  ll_list=glob(os.path.join(lowlossfolder,'spec_%02i*'%specnum))
  hl_list=glob(os.path.join(highlossfolder,'spec_%02i*'%specnum))
  
  ll_list.sort()
  hl_list.sort()
  
  hl_example=np.loadtxt(hl_list[0])
  
  sdict={}
  for indx in xrange(len(ll_list)):
    llspec=np.loadtxt(ll_list[indx])
    ZLPmax=llspec[[np.argmax(llspec[:,1])],0] #Get ZLP energy
    hlspec=np.loadtxt(hl_list[indx])
    hlspec[:,0]=np.array(np.round((hlspec[:,0]-ZLPmax)*10),dtype=np.int)
    hlspec=np.array(hlspec[:-1],dtype=np.int)
    hlspec=Series(data=hlspec[:,1],index=hlspec[:,0])
    sdict['%i'%indx]=hlspec
  df=DataFrame.fromDict(sdict)
  df=df.dropIncompleteRows()
  data=df.asMatrix()
  energydata=df.index
  return data,energydata

def smoothdata(data,windowsize=10,method='flat'):
  """
  Smooths your spectra.  Default method is moving window average with 
  windowsize = 10 channels.
  Other methods: 'hanning', 'hamming', 'bartlett', 'blackman'
  """
  smoothdata=data.copy()
  for i in xrange(data.shape[1]):
    smoothdata[:,i]=smooth(data[:,i],windowsize,method)
  return smoothdata

def offsetdata(data,offset=0.5):
  """
  Offsets each of your spectra by adding 50% (by default) of the full range of the first 
  spectrum.  For plotting.
  """
  offsetdata=data.copy()
  offset=offset*(np.max(data[:,0])-np.min(data[:,0]))
  for i in xrange(data.shape[1]):
    offsetdata[:,i]=data[:,i]+i*offset
  return offsetdata

def randomcolors(number):
  clist=map(tuple,np.random.random((3,number)))
  return clist

def pltdata_singleframe(data,energy_data):
  """
  Plot all spectra in data overlaid on one plot.  Probably useful to use the 
  offsetdata function to offset your data so that it does not overlap as much.
  """
  #mpl.rcParams['axes.color_cycle']=['black','red','green','blue']
  f=plt.figure(0)
  plt.clf()
  for i in xrange(data.shape[1]):
    plt.plot(energy_data,data[:,i],label=str(i+1))
  plt.legend()
  return f

def pltdata_multiframe(data,energy_data,framesperrow=3):
  """
  Plot each spectrum in data in its own subplot.
  """
  f=plt.figure(0)
  plt.clf()
  nrows=np.ceil(data.shape[1]/float(framesperrow))
  if nrows<1: 
    nrows=1
  for i in xrange(data.shape[1]):
    f.add_subplot(nrows,framesperrow,i+1)
    plt.plot(energy_data,data[:,i])
    plt.title('%i'%i)
  return f

'''
  f=plt.figure(0)
  evals['%i'%specnum]=vals
  for vec in xrange(vecs.shape[1]):
    plt.plot(xrange(1,len(vals[vec])+1),vals[vec])
    plt.savefig('pos%02i_eigenvals_ev%02i.png'%(specnum,vec))
    f.clf()
'''
'''
  # This is a 3D surface plot.  It has a bug where the spectra extend back to 0 eV.  
  ax=Axes3D(f)
  cc=lambda arg: colorConverter.to_rgba(arg, alpha=0.6)
  xs = df.index
  verts = []
  zs = xrange(1,smoothdata.shape[1]+1)
  for z in zs:
    ys = smoothdata[:,z-1]
    verts.append(zip(xs, ys))
  poly = PolyCollection(verts)
  poly.set_alpha(0.7)
  ax.add_collection3d(poly, zs=zs, zdir='y')
  ax.set_xlim3d(df.index[0], df.index[-1])
  ax.set_ylim3d(0, smoothdata.shape[1]+1)
  ax.set_zlim3d(np.min(smoothdata), np.max(smoothdata))
  plt.savefig('smoothed_progression_spec%s.png'%specnum)
  plt.clf()
'''

if __name__=='__main__':
  speclist=xrange(1,int(sys.argv[1]))
  nvecs=int(sys.argv[2])
  evals={}
  f=plt.figure()
  hlfolder='highloss'
  llfolder='lowloss'
  for specnum in speclist:
    #data,energydata=align_data_dualEELS(hlfolder,llfolder,specnum)
    #energydata=energydata/10.
    #dataplots=pltdata_singleframe(offsetdata(data),energydata)
    #dataplots.savefig('pos%02i_rawdata.png'%specnum)
    #smdata=offsetdata(smoothdata(data))
    #smdataplots=pltdata_singleframe(smdata,energydata)
    #smdataplots.savefig('pos%02i_smoothed_data.png'%specnum)
    tdata=np.loadtxt(ll_list[indx])
  evecs,evals=diff_ica(data,nvecs)
  savetxt(evecs,energydata[:-1].reshape((-1,1)),'pos%02i_ICA_eigenvectors.txt'%specnum)
  evecplots=pltdata_multiframe(evecs,energydata[:-1].reshape((-1,1)))
  evecplots.savefig('pos%02i_ICA_eigenvectors.png'%specnum)
