#!/usr/bin/env python
#
# A simple SPIDER image converter.
# Output format determined by extension.
# Original from http://www.wadsworth.org/spider_doc/spider/docs/tips/batch/index.html
# Modified 03/2010 MCS @ UCD: moved most of script into run function.
# Added conditional statements for calling script different ways from command
# line.  Though created for converting to/from SPIDER images, this script
# is generally useful for image conversion among formats.

import Image
import os, sys
from glob import glob

def run(filename,outfile):
  im = Image.open(filename)
  if im.format == 'SPIDER':
    # convert a Spider file, output determined by extension
    im = im.convert2byte()
    im.save(outfile)
  else:
    # convert a non-Spider file
    f, ext = os.path.splitext(outfile)
    if ext == '.spi':   
      im.save(outfile, 'SPIDER') # convert to Spider
    else:
      im.save(outfile)  # converts according to extension

if __name__ == '__main__':
  print "This script can be imported and used in python scripts for more flexibility."
  print "run spiconvert.py -h for more information on usage."
  flist=glob('*.spi')
  if len(sys.argv) is 1:
    print "Converting all spi files to png"
    for f in flist:
      try:
        run(f,f[:-3]+'png')
      except:
        print f, " could not be read as a SPIDER image file"

  elif len(sys.argv) is 2:
    if sys.argv[1]=='-h':
      print "- run spiconvert.py with no arguments to convert all spi files in current directory to png."
      print "- run spiconvert.py with a 3-letter file extension to convert all spi files in current directory to that file type."
      print "- run spiconvert.py with an input file and a 3-letter extenstion to convert the input file to that extension."
      print "- run spiconvert.py with an input file and an output file to convert the input file to that output file."      
    else:    
      print "Converting all SPIDER files to %s"%sys.argv[1]
      for f in flist:
        try:
          run(f,f[:-3]+sys.argv[1])
        except:
          print f, " could not be read as a SPIDER image file"
  else:
    filename = sys.argv[1]
    if len(sys.argv[1]) ==3 and len(sys.argv[2])==3:
      flist=glob('*.%s'%sys.argv[1])
      for f in flist:
        try:
          run(f,f[:-3]+sys.argv[2])
        except:
          print f, " could not be read as a %s image file"%sys.argv[1]
    elif len(sys.argv[2])==3 and not len(sys.argv[1]) ==3:
      outfile=filename[:-3]+sys.argv[2]
      run(filename,outfile)
    else:
      outfile  = sys.argv[2]
      run(filename,outfile)
