#-------------------------------------------------------------------------------
# $Id: common.py 2457 2013-05-06 09:27:59Z meissls $
#
# Project: EOxServer <http://eoxserver.org>
# Authors: Stephan Meissl <stephan.meissl@eox.at>
#
#-------------------------------------------------------------------------------
# Copyright (C) 2013 EOX IT Services GmbH
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
# copies of the Software, and to permit persons to whom the Software is 
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies of this Software or works derived from this Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#-------------------------------------------------------------------------------

"""
This module contains handlers and functions commonly used by the different WCS
2.0 operation implementations.
"""

from eoxserver.core.system import System


class WCS20ConfigReader(object):
    REGISTRY_CONF = {
        "name": "WCS 2.0 Configuration Reader",
        "impl_id": "services.ows.wcs20.WCS20ConfigReader"
    }

    def validate(self, config):
        pass

    def getPagingCountDefault(self):
        value = System.getConfig().getConfigValue("services.ows.wcs20", "paging_count_default")
        if value is not None:
            return int(value)
        
        return value
