import sys
import os
import signal
import subprocess
import traceback

NAME = 'EasyCluster'
MODULE = 'easycluster'
MAIN_MODULE = MODULE + '.__main__'
PIDFILE = '/var/run/easycluster.pid'

KEY_PATH = '/etc/easycluster_service.key'
INIT_PATH = '/etc/init.d/easycluster'

INIT_SCRIPT = '''\
#!/bin/sh
### BEGIN INIT INFO
# Provides:          easycluster
# Required-Start:    $network
# Required-Stop:     $network
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Control the EasyCluster service.
### END INIT INFO

# Author: Jared Stafford <jspenguin@jspenguin.org>

PATH=/sbin:/usr/sbin:/bin:/usr/bin

exec '%s' -m %s "$@"
'''

def install_service():
    temp_path = INIT_PATH + '~'

    with open(temp_path, 'w') as fp:
        fp.write(INIT_SCRIPT %  (sys.executable, __name__))

    os.chmod(temp_path, 0o755)
    os.rename(temp_path, INIT_PATH)

    for prog in (['update-rc.d', MODULE, 'defaults'],
                 ['/usr/lib/lsb/install_initd', MODULE]):
        
        try:
            subprocess.call(prog)
        except OSError:
            pass
        else:
            break
    else:
        print >>sys.stderr, "No method of installing initscripts found (tried Debian, LSB)"
        return 1
    return 0

def uninstall_service():
    for prog in (['update-rc.d', MODULE, 'remove', '-f'],
                 ['/usr/lib/lsb/remove_initd', MODULE]):
        try:
            subprocess.call(prog)
        except OSError:
            pass
        else:
            break
    else:
        print >>sys.stderr, "No method of uninstalling initscripts found (tried Debian, LSB)"
        return 1

    try:
        os.unlink(INIT_PATH)
    except (IOError, OSError):
        pass

    return 0

def start_service():
    return start_daemon()

def stop_service():
    return stop_daemon()

def is_daemon(pid, name):
    try:
        cmdline = file('/proc/%d/cmdline' % pid, 'r').read().split('\0')
        if cmdline[1] == '-m' and cmdline[2] == name:
            return True
    except Exception:
        pass
    return False

def read_pidfile(fil):
    try:
        return int(file(fil, 'r').read().strip())
    except Exception:
        return 0

def getpid():
    pid = read_pidfile(PIDFILE)
    if not pid:
        return
    
    if not is_daemon(pid, MAIN_MODULE):
        try:
            os.unlink(PIDFILE)
        except Exception:
            pass
        return 0
    
    return pid

def start_daemon():
    opid = getpid()
    if opid:
        print "%s is already running." % NAME
        return 1

    print "Starting %s:" % NAME,
    exitstat = subprocess.call([sys.executable, '-m', MAIN_MODULE, '-S', '-k', KEY_PATH, '-d', '-P', PIDFILE])
    if exitstat:
        print 'failed.'
        return 2
    print "ok."
    return 0

def stop_daemon():
    pid = getpid()
    if not pid:
        print "%s is not running." % NAME
        return 1
    try:
        print "Stopping %s:" % NAME,
        
        os.kill(pid, signal.SIGTERM)
        try:
            os.unlink(PIDFILE)
        except Exception:
            pass
        print "success."
        return 0
    except Exception:
        print "failed."
        return 2
        

def init_main():
    exitstat = 0

    cmd = sys.argv[1]
    if cmd == "start":
        exitstat = start_daemon()

    elif cmd == "stop":
        exitstat = stop_daemon()

    elif cmd == "reload" or cmd == "force-reload":
        pid = getpid()
        if pid:
            os.kill(pid, signal.SIGHUP)
            exitstat = 1
        else:
            print "%s is not running." % NAME

    elif cmd == "status":
        pid = getpid()
        if pid:
            print "%s is running." % NAME
        else:
            exitstat = 1
            print "%s is not running." % NAME

    elif cmd == "restart":
        stop_daemon()
        time.sleep(2)
        exitstat = start_daemon()
    else:

        print >>sys.stderr, "Usage: %s {start|stop|restart|reload|force-reload}" % sys.argv[0]
        exitstat = 1
    return exitstat

if __name__ == '__main__':
    sys.exit(init_main())
