import sys
import os
import traceback
import win32serviceutil
import win32service

sysroot = os.environ.get('SYSTEMROOT', r'c:\windows')
sysdir = os.path.join(sysroot, 'sysnative')
if not os.path.isdir(sysdir):
    sysdir = os.path.join(sysroot, 'system32')
KEY_PATH = os.path.join(sysdir, 'easycluster_service.key')
del sysdir, sysroot

class EasyClusterService(win32serviceutil.ServiceFramework):
    _svc_name_ = 'EasyCluster'
    _svc_display_name_ = 'EasyCluster remote execution service'

    server = None
        
    def SvcDoRun(self):
        '''Start and run the service.'''
        try:
            self.ReportServiceStatus(win32service.SERVICE_RUNNING)
            import easycluster.server
            import servicemanager
            servicemanager.LogInfoMsg('%s - Starting (%r)' % (self._svc_name_, sys.executable))
            easycluster.server.server_main(['-S', '-k', KEY_PATH])
        except Exception:
            import servicemanager
            servicemanager.LogErrorMsg(traceback.format_exc())

    def SvcStop(self):
        '''Stop the service.'''

        import easycluster.server
        import servicemanager
        servicemanager.LogInfoMsg('%s - Shutting down' % self._svc_name_)
        self.ReportServiceStatus(win32service.SERVICE_STOP_PENDING)
        easycluster.server.stop_server()

def _service_action(*args):
    return win32serviceutil.HandleCommandLine(EasyClusterService, argv=[''] + list(args))

def install_service():
    return _service_action('--startup', 'auto', 'install')

def uninstall_service():
    return _service_action('remove')

def start_service():
    return _service_action('start')

def stop_service():
    return _service_action('stop')

daemonize = None

if __name__ == '__main__':
    win32serviceutil.HandleCommandLine(EasyClusterService)
