#!/usr/bin/env python

try:
    from setuptools import setup
except ImportError:
    import ez_setup
    ez_setup.use_setuptools()
    from setuptools import setup

setup(name="EasyCluster",
      version="0.08",
      description="EasyCluster: a remote execution/clustering module for Python",
      author="Jared Stafford",
      author_email="jspenguin@gmail.com",
      url="http://pypi.python.org/pypi/EasyCluster",
      license="MIT License",
      packages=["easycluster"],
      entry_points = {
        'console_scripts': ['easycluster = easycluster.server:server_main'],
      },
      classifiers = [
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Development Status :: 3 - Alpha",
        "Environment :: Other Environment",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Topic :: System :: Clustering",
        "Topic :: System :: Distributed Computing",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Operating System :: Unix",
        "Operating System :: Microsoft :: Windows",
        ]
     )
