###############################################################################
#    Copyright (C) 2007 Cody Precord                                          #
#    staff@editra.org                                                         #
#                                                                             #
#    Editra is free software; you can redistribute it and#or modify           #
#    it under the terms of the GNU General Public License as published by     #
#    the Free Software Foundation; either version 2 of the License, or        #
#    (at your option) any later version.                                      #
#                                                                             #
#    Editra is distributed in the hope that it will be useful,                #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of           #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            #
#    GNU General Public License for more details.                             #
#                                                                             #
#    You should have received a copy of the GNU General Public License        #
#    along with this program; if not, write to the                            #
#    Free Software Foundation, Inc.,                                          #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.                #
###############################################################################

"""
#-----------------------------------------------------------------------------#
# FILE: matlab.py                                                             #
# AUTHOR: Cody Precord                                                        #
#                                                                             #
# SUMMARY:                                                                    #
# Lexer configuration module for Matlab and Octave                            #
#                                                                             #
# @todo:                                                                      #
#                                                                             #
#-----------------------------------------------------------------------------#
"""

__author__ = "Cody Precord <cprecord@editra.org>"
__svnid__ = "$Id: matlab.py 286 2007-07-12 11:44:51Z CodyPrecord $"
__revision__ = "$Revision: 286 $"

#-----------------------------------------------------------------------------#
import synglob
#-----------------------------------------------------------------------------#

#---- Keyword Definitions ----#
MATLAB_KW = (0, "break case catch continue else elseif end for function "
                "global if otherwise persistent return switch try while")

OCTAVE_KW = (0, "break case catch continue do else elseif end "
                "end_unwind_protect endfor endif endswitch endwhile for "
                "function endfunction global if otherwise persistent return "
                "switch try until unwind_protect unwind_protect_cleanup while")
#---- End Keyword Definitions ----#

#---- Syntax Style Specs ----#
SYNTAX_ITEMS = [('STC_MATLAB_COMMAND', 'funct_style'),
                ('STC_MATLAB_COMMENT', 'comment_style'),
                ('STC_MATLAB_DEFAULT', 'default_style'),
                ('STC_MATLAB_DOUBLEQUOTESTRING', 'string_style'),
                ('STC_MATLAB_IDENTIFIER', 'default_style'),
                ('STC_MATLAB_KEYWORD', 'keyword_style'),
                ('STC_MATLAB_NUMBER', 'number_style'),
                ('STC_MATLAB_OPERATOR', 'operator_style'),
                ('STC_MATLAB_STRING', 'string_style')]

#---- Extra Properties ----#
FOLD = ('fold', '1')
#-----------------------------------------------------------------------------#

#---- Required Module Functions ----#
def Keywords(lang_id=0):
    """Returns Specified Keywords List
    @keyword lang_id: used to select specific subset of keywords

    """
    if lang_id == synglob.ID_LANG_MATLAB:
        return [MATLAB_KW]
    elif lang_id == synglob.ID_LANG_OCTAVE:
        return [OCTAVE_KW]
    else:
        return list()

def SyntaxSpec(lang_id=0):
    """Syntax Specifications
    @keyword lang_id: used for selecting a specific subset of syntax specs

    """
    if lang_id in [synglob.ID_LANG_MATLAB, synglob.ID_LANG_OCTAVE]:
        return SYNTAX_ITEMS
    else:
        return list()

def Properties(lang_id=0):
    """Returns a list of Extra Properties to set
    @keyword lang_id: used to select a specific set of properties

    """
    if lang_id in [synglob.ID_LANG_MATLAB, synglob.ID_LANG_OCTAVE]:
        return [FOLD]
    else:
        return list()

def CommentPattern(lang_id=0):
    """Returns a list of characters used to comment a block of code
    @keyword lang_id: used to select a specific subset of comment pattern(s)

    """
    if lang_id == synglob.ID_LANG_MATLAB:
        return [u'%']
    elif lang_id == synglob.ID_LANG_OCTAVE:
        return [u'#']
    else:
        return list()

#---- End Required Module Functions ----#

#---- Syntax Modules Internal Functions ----#
def KeywordString():
    """Returns the specified Keyword String
    @note: not used by most modules

    """
    return None

#---- End Syntax Modules Internal Functions ----#
