from elements import Elements

import sys

xml_string = """
<message>
	<integer>12</integer>
</message>
"""

class Message(Elements):
  _tag = 'message'
  _children = Elements._children.copy()    
  
  _children['integer'] = ('myint', int)

  def __init__(self, myint=False, text=None):
    self.myint = myint
    self.text = text

def test_int():
    global xml_string
    e = Message()
    e.from_string(xml_string)
    
    assert e.myint == 12
    assert type(e.myint) == int

    for val in [-1, 0, 1, 1000, 9999, sys.maxint]:
        e = Message(myint=val)
        xml_string = e.to_string()
        e = Message()
        e.from_string(xml_string) # Parse our own output
        assert e.myint == val
        
if __name__ == '__main__':
	test_int()