from elements import Elements

NS1 = "ns1"
NS2 = "ns2"

xml_string = """
<datastore xmlns="ns1">
	<name>Dag Brattli</name>
	<myname xmlns="ns2">Dag Brattli</myname>
</datastore>
"""

class Datastore(Elements):
  _tag = 'datastore'
  _namespace = NS1

  _children = Elements._children.copy()
  
  _children['name'] = ('name', unicode)

  def __init__(self, name=False, text=None):
    self.name = name
    self.text = text

class MyDatastore(Datastore):  
  _children = Datastore._children.copy()
  _children['{%s}myname' % NS2] = ('my_name', unicode)

  def __init__(self, my_name=False, text=None):
      Datastore.__init__(self)
      
      self.my_name = my_name
      self.text = text


def test_namespaces():
    global xml_string
    
    e = MyDatastore()
    e.from_string(xml_string)
    
    assert e.name == 'Dag Brattli'
    assert e.my_name == 'Dag Brattli'
    
    xml_string = e.to_string()
    e = MyDatastore()
    e.from_string(xml_string)

    assert e.name == 'Dag Brattli'
    assert e.my_name == 'Dag Brattli'

if __name__ == '__main__':
	test_namespaces()