from elements import Elements

xml_string = """
<name>
	<firstname>Dag</firstname>
	<lastname>Brattli \xc3\xb8</lastname>
</name>
"""

class Name(Elements):
  _tag = 'name'
  _children = Elements._children.copy()    
  
  _children['firstname'] = ('first_name', str)
  _children['lastname'] = ('last_name', unicode)

  def __init__(self, first_name=None, last_name=None, text=None):
    self.first_name = None
    self.last_name = None
    self.text = None

def test_strings():
    e = Name()
    e.from_string(xml_string)
    
    print repr(e.first_name)
    assert e.first_name == 'Dag'
    assert type(e.first_name) == str
    
    print repr(e.last_name)
    assert e.last_name == u'Brattli \xf8'
    assert type(e.last_name) == unicode
    
    # Now we parse our own output
    new_xml = e.to_string()
    e = Name()
    e.from_string(new_xml)

    print repr(e.first_name)
    assert e.first_name == 'Dag'
    assert type(e.first_name) == str
    
    print repr(e.last_name)
    assert e.last_name == u'Brattli \xf8'
    assert type(e.last_name) == unicode

if __name__ == '__main__':
	test_strings()