# -----------------------------------------------------------------------------
# _filter.py - Tracing filters.
#
# 2012, Ben Eills
#
# Copyright 2012, 2014, Ensoft Ltd.
# -----------------------------------------------------------------------------

"""Tracing filters."""

__all__ = (
    "EntrailsFilter",
    "LibraryFilter",
    "SelfFilter",
)


class EntrailsFilter(object):
    """
    Base class for filters.

    Returns True if object remains unfiltered.
    Must be very fast at executing, since we deal with so many objects.
    """
    def filter(self, frameobjects):
        """
        Trivial filter (allowing all events to pass through)
        """
        return frameobjects


class LibraryFilter(EntrailsFilter):
    """
    Filters out major 3rd party libraries and Standard Library.
    """
    matches = ("/usr/lib", "/usr/local/lib", "/usr/lib64", "/twisted", "/zope")

    def filter(self, frameobject):
        for m in self.matches:
            if m in frameobject['co_filename']:
                return False
        return True


class SelfFilter(EntrailsFilter):
    """
    Filter out EnTrails events.

    Performance-wise, it might be better to have this hardcoded below
      to save a couple of JMP statements, but architecturally this is
      where it goes.
    """
    matches = ("remove_output", "end_trace")

    def filter(self, frameobject):
        for m in self.matches:
            if m in frameobject['co_name']:
                return False
        return True

